<?php
//USING
require_once '../Class/model/RecebimentosModel.php';
require_once '../Class/model/ClientesModel.php';
require_once '../Class/model/FormasPagamentosModel.php';
include_once('../Database/MySQL.Aux.php');

/**
 * BaixaRecebimentosControl - Controle das baixas dos recebimentos
 *
 * Essa classe controla as baixas de recebimentos
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */
class BaixaRecebimentosControl
{
	protected $id;
	protected $action;
	protected $deletar;

	public function setId()
	{
		if (isset($_GET['id']))
		{
			$this->id = $_GET['id'];
		}
	}

	public function getId()
	{
		return $this->id;
	}

	public function setAction()
	{
		if (isset($_POST['action']))
		{
			$this->action = $_POST['action'];
		}
	}

	public function getAction()
	{
		return $this->action;
	}

	public function setDel()
	{
		if (isset($_GET['del']))
		{
			$this->deletar = $_GET['del'];
		}
	}

	public function getDel()
	{
		return $this->deletar;
	}

	//Constructor
	public function __construct()
	{

	}

	public function GetData($id)
	{
		$result = new RecebimentosModel();
		$aux = new MySQLAux();
		
		$result->setId($id);
		$result->setForma($_POST['forma']);
		$result->setDtRecebimento($aux->FormataData($_POST['databaixa']));
		$result->setCheque($_POST['cheque']);
		$result->setBaixadoem($aux->DBDateNow());

		return $result->updateBaixas();
	}
	
	public function RetornaValorTotal($id)
	{
		$model = new RecebimentosModel();
		$model->load($id);
		
		$total = ($model->getValor() - $model->getDesconto()) + ($model->getMulta() + $model->getJuros());

		return $total; 
	}
	
	public function RetornaCliente($id)
	{
		$result = new ClientesModel();
		$result->load($id);
		return $result->getNomeFantasia();
	}
	
	public function RetornaFormaPagamento($id)
	{
		$result = new FormasPagamentosModel();
		$result->load($id);
		return $result->getNome();
	}
}

?>