<?php
//USING
require_once '../Class/model/FaturasModel.php';
require_once '../Class/model/FaturasDescricaoModel.php';
include_once('../Database/MySQL.Aux.php');

/**
 * ClientesControl - Controle das faturas do sistema
 *
 * Essa classe controla as requisicoes da classe Faturas
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */
class FaturasControl
{
	protected $id;
	protected $action;
	protected $deletar;

	public function setId()
	{
		if (isset($_GET['id']))
		{
			$this->id = $_GET['id'];
		}
	}

	public function getId()
	{
		return $this->id;
	}

	public function setAction()
	{
		if (isset($_POST['action']))
		{
			$this->action = $_POST['action'];
		}
	}

	public function getAction()
	{
		return $this->action;
	}

	public function setDel()
	{
		if (isset($_GET['del']))
		{
			$this->deletar = $_GET['del'];
		}
	}

	public function getDel()
	{
		return $this->deletar;
	}

	//Constructor
	public function __construct()
	{

	}

	public function GetData()
	{
		$result = new FaturasModel();
		$aux = new MySQLAux();
		
		$result->setId($_POST['Id']);
		$result->setCliente($_POST['clientes']);
		$result->setPasta($_POST['pastas']);
		$result->setDtEmissao($aux->FormataData($_POST['dataemissao']));
		$result->setDtVencimento($aux->FormataData($_POST['datavencimento']));
		$result->setNumNota($_POST['numnota']);
		
		$result->save();
		return $result->getId();
	}
	
	public function GetDataDescricao($id, $idFatura, $descricao, $tiposrecebimentos, $valor)
	{
		$aux = new MySQLAux();	
		$resultDescricao = new FaturasDescricaoModel();
		$resultDescricao->setId($id);
		$resultDescricao->setFatura($idFatura);
		$resultDescricao->setDescricao($descricao);
		$resultDescricao->setTipoRecebimento($tiposrecebimentos);
		$resultDescricao->setValor($aux->getValorEN($valor));
		
		return $resultDescricao->save();
	}
	
	public function RetornaCliente($id)
	{
		$cliente = new ClientesModel();
		$cliente->load($id);
		return $cliente->getNomeFantasia();
	}
	
	public function RetornaPasta($id)
	{
		$pasta = new PastasModel();
		$pasta->load($id);
		return $pasta->getNome();
	}
	
	public function RetornaValor($id)
	{
		$resultDescricao = new FaturasDescricaoModel();
		$aux = new MySQLAux();	
		
		$total = $aux->getValorBR(0.00);
		
		foreach ($resultDescricao->listAllByFatura($id) as $item) {
			$total += $item->getValor();
		}
		
		return $total;
	}
}

?>