<?php
//USING
require_once '../Database/MySQL.Connection.php';
include_once('../Database/MySQL.Query.php');
include_once('../Database/MySQL.Aux.php');

/**
 * LoginModel
 *
 * Essa classe controla as propriedades e requisies do banco de dados das cidades
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */

class CidadesModel
{
	//Attributes
	protected $id;
	protected $uf;
	protected $cidade;
	protected $conn;

	public function getId()
	{
		return $this->id;
	}

	public function setId($pValue)
	{
		$this->id = $pValue;
	}

	public function setUf($pValue)
	{
		$this->uf = $pValue;
	}

	public function getUf()
	{
		return $this->uf;
	}

	public function setCidade($pValue)
	{
		$this->cidade= $pValue;
	}

	public function getCidade()
	{
		return $this->cidade;
	}

	//Constructor
	public function __construct()
	{
		$this->conn = new ConnectionFactory();
	}

	//Functions
	public function fillAttributes($row)
	{
		$this->setId($row['Id']);
		$this->setUf($row['Uf']);
		$this->setCidade($row['Cidade']);
	}

	public function load($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_cidades WHERE Id = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}

	public function save()
	{
		try
		{
			if($this->id  > 0)
			{
				return $this->update();
			}
			else
			{
				return $this->insert();
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function insert()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Uf',$this->getUf(),'text'));
			array_push($fields, MySQLAux::CreateField('Cidade',$this->getCidade(),'text'));
			$this->id = ConnectionFactory::ExecuteInsert(MySQLQuery::Insert('mfin_cidades',$fields));
			$success = $this->id > 0;

			return ($success);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function update()
	{
		try
		{

			$fields = array();
			array_push($fields, MySQLAux::CreateField('Uf',$this->getUf(),'text'));
			array_push($fields, MySQLAux::CreateField('Cidade',$this->getCidade(),'text'));

			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_cidades',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{

			echo($err);
			return false;
		}
	}

	public function delete()
	{
		try
		{
			return ($this->conn->ExecuteAffected("DELETE FROM mfin_cidades WHERE Id = $this->id") > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function listAll()
	{
		return self::GenericList('SELECT * FROM mfin_cidades ORDER BY Id ASC');
	}
	
	public function listAllByUf($Idestado)
	{
		return self::GenericList("SELECT * FROM  mfin_cidades WHERE Uf = $Idestado");
	}

	public function GenericList($pQuery)
	{
		$result = $this->conn->ExecuteSelect($pQuery);
		$list = array();
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH))
			{
				$item = new CidadesModel();
				$item->fillAttributes($row);
				array_push($list, $item);
			}
		}
	
		return $list;
	}
}
