<?php
//USING
require_once '../Database/MySQL.Connection.php';
include_once('../Database/MySQL.Query.php');
include_once('../Database/MySQL.Aux.php');

/**
 * LoginModel
 *
 * Essa classe controla as propriedades e requisies do banco de dados dos usurios
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */

class ClientesModel
{
	//Attributes
	protected $id;
	protected $estado;
	protected $cidade;
	protected $conta;
	protected $tipo;
	protected $cpf;
	protected $cnpj;
	protected $nomeFantasia;
	protected $razaoSocial;
	protected $inscricaoMunicipal;
	protected $inscricaoEstadual;
	protected $cep;
	protected $endereco;
	protected $bairro;
	protected $numero;
	protected $complemento;
	protected $telefone;
	protected $celular;
	protected $fax;
	protected $email;
	protected $outrasInformacoes;
	protected $contaResultado;
	protected $conn;

	public function setId($pValue)
	{
		$this->id = $pValue;
	}

	public function getId()
	{
		return $this->id;
	}

	public function setEstado($pValue)
	{
		$this->estado = $pValue;
	}

	public function getEstado()
	{
		return $this->estado;
	}

	public function setCidade($pValue)
	{
		$this->cidade = $pValue;
	}

	public function getCidade()
	{
		return $this->cidade;
	}

	public function setConta($pValue)
	{
		$this->conta = $pValue;
	}

	public function getConta()
	{
		return $this->conta;
	}

	public function setTipo($pValue)
	{
		$this->tipo = $pValue;
	}

	public function getTipo()
	{
		return $this->tipo;
	}

	public function setCpf($pValue)
	{
		$this->cpf = $pValue;
	}

	public function getCpf()
	{
		return $this->cpf;
	}

	public function setCnpj($pValue)
	{
		$this->cnpj = $pValue;
	}

	public function getCnpj()
	{
		return $this->cnpj;
	}

	public function setNomeFantasia($pValue)
	{
		$this->nomeFantasia = $pValue;
	}

	public function getNomeFantasia()
	{
		return $this->nomeFantasia;
	}

	public function setRazaoSocial($pValue)
	{
		$this->razaoSocial = $pValue;
	}

	public function getRazaoSocial()
	{
		return $this->razaoSocial;
	}

	public function setInscricaoMunicipal($pValue)
	{
		$this->inscricaoMunicipal = $pValue;
	}

	public function getInscricaoMunicipal()
	{
		return $this->inscricaoMunicipal;
	}

	public function setInscricaoEstadual($pValue)
	{
		$this->inscricaoEstadual = $pValue;
	}

	public function getInscricaoEstadual()
	{
		return $this->inscricaoEstadual;
	}

	public function setCep($pValue)
	{
		$this->cep = $pValue;
	}

	public function getCep()
	{
		return $this->cep;
	}

	public function setEndereco($pValue)
	{
		$this->endereco = $pValue;
	}

	public function getEndereco()
	{
		return $this->endereco;
	}

	public function setBairro($pValue)
	{
		$this->bairro = $pValue;
	}

	public function getBairro()
	{
		return $this->bairro;
	}

	public function setNumero($pValue)
	{
		$this->numero = $pValue;
	}

	public function getNumero()
	{
		return $this->numero;
	}

	public function setComplemento($pValue)
	{
		$this->complemento = $pValue;
	}

	public function getComplemento()
	{
		return $this->complemento;
	}

	public function setTelefone($pValue)
	{
		$this->telefone = $pValue;
	}

	public function getTelefone()
	{
		return $this->telefone;
	}

	public function setCelular($pValue)
	{
		$this->celular = $pValue;
	}

	public function getCelular()
	{
		return $this->celular;
	}

	public function setFax($pValue)
	{
		$this->fax = $pValue;
	}

	public function getFax()
	{
		return $this->fax;
	}

	public function setEmail($pValue)
	{
		$this->email = $pValue;
	}

	public function getEmail()
	{
		return $this->email;
	}

	public function setOutrasInformacoes($pValue)
	{
		$this->outrasInformacoes = $pValue;
	}

	public function getOutrasInformacoes()
	{
		return $this->outrasInformacoes;
	}

	public function setContaResultado($pValue)
	{
		$this->contaResultado = $pValue;
	}

	public function getContaResultado()
	{
		return $this->contaResultado;
	}
	
	//Constructor
	public function __construct()
	{
		$this->conn = new ConnectionFactory();
	}

	//Functions
	public function fillAttributes($row)
	{
		$this->setId($row['Id']);
		$this->setEstado($row['Estado']);
		$this->setCidade($row['Cidade']);
		$this->setConta($row['Conta']);
		$this->setTipo($row['Tipo']);
		$this->setCpf($row['Cpf']);
		$this->setCnpj($row['Cnpj']);
		$this->setNomeFantasia($row['NomeFantasia']);
		$this->setRazaoSocial($row['RazaoSocial']);
		$this->setInscricaoMunicipal($row['InscricaoMunicipal']);
		$this->setInscricaoEstadual($row['InscricaoEstadual']);
		$this->setCep($row['Cep']);
		$this->setEndereco($row['Endereco']);
		$this->setBairro($row['Bairro']);
		$this->setNumero($row['Numero']);
		$this->setComplemento($row['Complemento']);
		$this->setTelefone($row['Telefone']);
		$this->setCelular($row['Celular']);
		$this->setFax($row['Fax']);
		$this->setEmail($row['Email']);
		$this->setOutrasInformacoes($row['OutrasInformacoes']);
		$this->setContaResultado($row['ContaResultado']);
	}

	public function load($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_clientes WHERE Id = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}

	public function save()
	{
		try
		{
			if($this->id  > 0)
			{
				return $this->update();
			}
			else
			{
				return $this->insert();
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function insert()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Estado',$this->getEstado(),'text'));
			array_push($fields, MySQLAux::CreateField('Cidade',$this->getCidade(),'text'));
			array_push($fields, MySQLAux::CreateField('Conta',$this->getConta(),'text'));
			array_push($fields, MySQLAux::CreateField('Tipo',$this->getTipo(),'text'));
			array_push($fields, MySQLAux::CreateField('Cpf',$this->getCpf(),'text'));
			array_push($fields, MySQLAux::CreateField('Cnpj',$this->getCnpj(),'text'));
			array_push($fields, MySQLAux::CreateField('NomeFantasia',$this->getNomeFantasia(),'text'));
			array_push($fields, MySQLAux::CreateField('RazaoSocial',$this->getRazaoSocial(),'text'));
			array_push($fields, MySQLAux::CreateField('InscricaoMunicipal',$this->getInscricaoMunicipal(),'text'));
			array_push($fields, MySQLAux::CreateField('InscricaoEstadual',$this->getInscricaoEstadual(),'text'));
			array_push($fields, MySQLAux::CreateField('Cep',$this->getCep(),'text'));
			array_push($fields, MySQLAux::CreateField('Endereco',$this->getEndereco(),'text'));
			array_push($fields, MySQLAux::CreateField('Bairro',$this->getBairro(),'text'));
			array_push($fields, MySQLAux::CreateField('Numero',$this->getNumero(),'text'));
			array_push($fields, MySQLAux::CreateField('Complemento',$this->getComplemento(),'text'));
			array_push($fields, MySQLAux::CreateField('Telefone',$this->getTelefone(),'text'));
			array_push($fields, MySQLAux::CreateField('Celular',$this->getCelular(),'text'));
			array_push($fields, MySQLAux::CreateField('Fax',$this->getFax(),'text'));
			array_push($fields, MySQLAux::CreateField('Email',$this->getEmail(),'text'));
			array_push($fields, MySQLAux::CreateField('OutrasInformacoes',$this->getOutrasInformacoes(),'text'));
			array_push($fields, MySQLAux::CreateField('ContaResultado',$this->getContaResultado(),'number'));
			$this->id = $this->conn->ExecuteInsert(MySQLQuery::Insert('mfin_clientes',$fields));
			$success = $this->id > 0;

			return ($success);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function update()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Estado',$this->getEstado(),'text'));
			array_push($fields, MySQLAux::CreateField('Cidade',$this->getCidade(),'text'));
			array_push($fields, MySQLAux::CreateField('Conta',$this->getConta(),'text'));
			array_push($fields, MySQLAux::CreateField('Tipo',$this->getTipo(),'text'));
			array_push($fields, MySQLAux::CreateField('Cpf',$this->getCpf(),'text'));
			array_push($fields, MySQLAux::CreateField('Cnpj',$this->getCnpj(),'text'));
			array_push($fields, MySQLAux::CreateField('NomeFantasia',$this->getNomeFantasia(),'text'));
			array_push($fields, MySQLAux::CreateField('RazaoSocial',$this->getRazaoSocial(),'text'));
			array_push($fields, MySQLAux::CreateField('InscricaoMunicipal',$this->getInscricaoMunicipal(),'text'));
			array_push($fields, MySQLAux::CreateField('InscricaoEstadual',$this->getInscricaoEstadual(),'text'));
			array_push($fields, MySQLAux::CreateField('Cep',$this->getCep(),'text'));
			array_push($fields, MySQLAux::CreateField('Endereco',$this->getEndereco(),'text'));
			array_push($fields, MySQLAux::CreateField('Bairro',$this->getBairro(),'text'));
			array_push($fields, MySQLAux::CreateField('Numero',$this->getNumero(),'text'));
			array_push($fields, MySQLAux::CreateField('Complemento',$this->getComplemento(),'text'));
			array_push($fields, MySQLAux::CreateField('Telefone',$this->getTelefone(),'text'));
			array_push($fields, MySQLAux::CreateField('Celular',$this->getCelular(),'text'));
			array_push($fields, MySQLAux::CreateField('Fax',$this->getFax(),'text'));
			array_push($fields, MySQLAux::CreateField('Email',$this->getEmail(),'text'));
			array_push($fields, MySQLAux::CreateField('OutrasInformacoes',$this->getOutrasInformacoes(),'text'));
			array_push($fields, MySQLAux::CreateField('ContaResultado',$this->getContaResultado(),'number'));
			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_clientes',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{

			echo($err);
			return false;
		}
	}

	public function delete()
	{
		try
		{
			return ($this->conn->ExecuteAffected("DELETE FROM mfin_clientes WHERE Id = $this->id") > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function listAll()
	{	
		return $this->GenericList('SELECT * FROM mfin_clientes ORDER BY NomeFantasia ASC');
	}
	
	public function GenericList($pQuery)
	{
		$result = $this->conn->ExecuteSelect($pQuery);
		$list = array();
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH))
			{
				$item = new ClientesModel();
				$item->fillAttributes($row);
				array_push($list, $item);
			}
		}
	
		return $list;
	}
}
