<?php
//USING
require_once '../Database/MySQL.Connection.php';
include_once('../Database/MySQL.Query.php');
include_once('../Database/MySQL.Aux.php');

/**
 * FaturasModel
 *
 * Essa classe controla as propriedades e requisies das faturas
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */

class FaturasModel
{
	//Attributes
	protected $id;
	protected $cliente;
	protected $pasta;
	protected $dtEmissao;
	protected $dtVencimento;
	protected $numNota;
	protected $conn;

	public function setId($pValue)
	{
		$this->id = $pValue;
	}

	public function getId()
	{
		return $this->id;
	}

	public function setCliente($pValue)
	{
		$this->cliente = $pValue;
	}

	public function getCliente()
	{
		return $this->cliente;
	}

	public function setPasta($pValue)
	{
		$this->pasta = $pValue;
	}

	public function getPasta()
	{
		return $this->pasta;
	}

	public function setDtEmissao($pValue)
	{
		$this->dtEmissao = $pValue;
	}

	public function getDtEmissao()
	{
		return $this->dtEmissao;
	}

	public function setDtVencimento($pValue)
	{
		$this->dtVencimento = $pValue;
	}

	public function getDtVencimento()
	{
		return $this->dtVencimento;
	}
	
	public function setNumNota($pValue)
	{
		$this->numNota = $pValue;
	}

	public function getNumNota()
	{
		return $this->numNota;
	}

	//Constructor
	public function __construct()
	{
		$this->conn = new ConnectionFactory();
	}

	//Functions
	public function fillAttributes($row)
	{
		$this->setId($row['Id']);
		$this->setCliente($row['Cliente']);
		$this->setPasta($row['Pasta']);
		$this->setDtEmissao($row['DtEmissao']);
		$this->setDtVencimento($row['DtVencimento']);
		$this->setNumNota($row['NumNota']);
	}

	public function load($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_faturas WHERE Id = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}

	public function save()
	{
		try
		{
			if($this->id  > 0)
			{
				return $this->update();
			}
			else
			{
				return $this->insert();
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function insert()
	{
		try
		{
			$fields = array();
			
			array_push($fields, MySQLAux::CreateField('Cliente',$this->getCliente(),'number'));
			array_push($fields, MySQLAux::CreateField('Pasta',$this->getPasta(),'number'));
			array_push($fields, MySQLAux::CreateField('DtEmissao',$this->getDtEmissao(),'datetime'));
			array_push($fields, MySQLAux::CreateField('DtVencimento',$this->getDtVencimento(),'datetime'));
			array_push($fields, MySQLAux::CreateField('NumNota',$this->getNumNota(),'number'));
			$this->setId($this->conn->ExecuteInsert(MySQLQuery::Insert('mfin_faturas',$fields))); 
			$success = $this->id > 0;

			return ($success);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function update()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Cliente',$this->getCliente(),'number'));
			array_push($fields, MySQLAux::CreateField('Pasta',$this->getPasta(),'number'));
			array_push($fields, MySQLAux::CreateField('DtEmissao',$this->getDtEmissao(),'datetime'));
			array_push($fields, MySQLAux::CreateField('DtVencimento',$this->getDtVencimento(),'datetime'));
			array_push($fields, MySQLAux::CreateField('NumNota',$this->getNumNota(),'number'));

			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_faturas',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function delete()
	{
		try
		{
			return ($this->conn->ExecuteAffected("DELETE FROM mfin_faturas WHERE Id = $this->id") > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function listAll()
	{
		return self::GenericList('SELECT * FROM mfin_faturas ORDER BY Id ASC');
	}

	public function GenericList($pQuery)
	{
		$result = $this->conn->ExecuteSelect($pQuery);
		$list = array();
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH))
			{
				$item = new FaturasModel();
				$item->fillAttributes($row);
				array_push($list, $item);
			}
		}	
		return $list;
	}
}
?>