<?php
//USING
require_once '../Database/MySQL.Connection.php';
include_once('../Database/MySQL.Query.php');
include_once('../Database/MySQL.Aux.php');

/**
 * LoginModel
 *
 * Essa classe controla as propriedades e requisies do banco de dados dos usurios
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */

class LoginModel
{
	//Attributes
	protected $id;
	protected $login;
	protected $nome;
	protected $senha;
	protected $email;	
	protected $conn;
	
	public function setId($pValue)
	{
		$this->id = $pValue;
	}

	public function getId()
	{
		return $this->id;
	}

	public function setLogin($pValue)
	{
		$this->login = $pValue;
	}

	public function getLogin()
	{
		return $this->login;
	}

	public function setNome($pValue)
	{
		$this->nome = $pValue;
	}

	public function getNome()
	{
		return $this->nome;
	}

	public function setSenha($pValue)
	{
		$this->senha = $pValue;
	}

	public function getSenha()
	{
		return $this->senha;
	}

	public function setEmail($pValue)
	{
		$this->email = $pValue;
	}

	public function getEmail()
	{
		return $this->email;
	}

	//Constructor
	public function __construct()
	{
		$this->conn = new ConnectionFactory();
	}

	//Functions
	public function fillAttributes($row)
	{
		$this->setId($row['Id']);
		$this->setLogin($row['Login']);
		$this->setNome($row['Nome']);
		$this->setEmail($row['Email']);
	}

	public function load($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_usuarios WHERE Id = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}
	
	public function verificaLoginConecta($login, $senha)
	{		
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_usuarios WHERE Login = '$login' AND Senha = '$senha'");
		
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}
	
	public function verificaLogin($login, $id)
	{
		$conn = new ConnectionFactory();
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_usuarios WHERE Login = '$login' AND Id != '$id'");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}

	public function save()
	{
		try
		{
			if($this->id  > 0)
			{
				return $this->update();
			}
			else
			{
				return $this->insert();
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function insert()
	{
		try
		{
			$conn = new ConnectionFactory();
			
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Login',$this->login,'text'));
			array_push($fields, MySQLAux::CreateField('Nome',$this->nome,'text'));
			array_push($fields, MySQLAux::CreateField('Senha',$this->senha,'text'));
			array_push($fields, MySQLAux::CreateField('Email',$this->email,'text'));
			$this->id = $conn->ExecuteInsert(MySQLQuery::Insert('mfin_usuarios',$fields));
			$success = $this->id > 0;

			return ($success);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function update()
	{
		try
		{
			$conn = new ConnectionFactory();
			
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Login',$this->login,'text'));
			array_push($fields, MySQLAux::CreateField('Nome',$this->nome,'text'));
			array_push($fields, MySQLAux::CreateField('Senha',$this->senha,'text'));
			array_push($fields, MySQLAux::CreateField('Email',$this->email,'text'));

			return ($conn->ExecuteAffected(MySQLQuery::Update('mfin_usuarios',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{

			echo($err);
			return false;
		}
	}

	public function delete()
	{
		try
		{
			$conn = new ConnectionFactory();
			
			if ($this->id != 1){
				return ($conn->ExecuteAffected("DELETE FROM mfin_usuarios WHERE Id = $this->id") > 0);
			}
			else 
			{
				return 0;
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function listAll()
	{
		return self::GenericList('SELECT * FROM mfin_usuarios ORDER BY Id ASC');
	}

	public function GenericList($pQuery)
	{
		$conn = new ConnectionFactory();
		
		$result = $conn->ExecuteSelect($pQuery);
		$list = array();
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH))
			{
				$item = new LoginModel();
				$item->fillAttributes($row);
				array_push($list, $item);
			}
		}	
		return $list;
	}
}
