<?php
//USING
require_once '../Database/MySQL.Connection.php';
include_once('../Database/MySQL.Query.php');
include_once('../Database/MySQL.Aux.php');

/**
 * LoginModel
 *
 * Essa classe controla as propriedades e requisies do banco de dados dos usurios
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */

class PagamentosModel
{
	//Attributes
	protected $id;
	protected $banco;
	protected $fornecedor;
	protected $cliente;
	protected $pasta;
	protected $formaPagamento;
	protected $emissao;
	protected $vencimento;
	protected $numFatura;
	protected $detalhe;
	protected $valor;
	protected $ir;
	protected $pis;
	protected $cofins;
	protected $csll;
	protected $inss;
	protected $juros;
	protected $iss;
	protected $multa;
	protected $desconto;
	protected $dtPagamento;
	protected $cheque;
	protected $baixadoem;
	protected $conn;

	public function setId($pValue)
	{
		$this->id = $pValue;
	}
	
	public function getId()
	{
		return $this->id;
	}

	public function setBanco($pValue)
	{
		$this->banco = $pValue;
	}

	public function getBanco()
	{
		return $this->banco;
	}

	public function setFornecedor($pValue)
	{
		$this->fornecedor = $pValue;
	}

	public function getFornecedor()
	{
		return $this->fornecedor;
	}

	public function setCliente($pValue)
	{
		$this->cliente = $pValue;
	}

	public function getCliente()
	{
		return $this->cliente;
	}

	public function setPasta($pValue)
	{
		$this->pasta = $pValue;
	}

	public function getPasta()
	{
		return $this->pasta;
	}

	public function setFormaPagamento($pValue)
	{
		$this->formaPagamento = $pValue;
	}

	public function getFormaPagamento()
	{
		return $this->formaPagamento;
	}

	public function setEmissao($pValue)
	{
		$this->emissao = $pValue;
	}

	public function getEmissao()
	{
		return $this->emissao;
	}

	public function setVencimento($pValue)
	{
		$this->vencimento = $pValue;
	}

	public function getVencimento()
	{
		return $this->vencimento;
	}

	public function setNumFatura($pValue)
	{
		$this->numFatura = $pValue;
	}

	public function getNumFatura()
	{
		return $this->numFatura;
	}

	public function setDetalhe($pValue)
	{
		$this->detalhe = $pValue;
	}

	public function getDetalhe()
	{
		return $this->detalhe;
	}

	public function setValor($pValue)
	{
		$this->valor = $pValue;
	}

	public function getValor()
	{
		return $this->valor;
	}

	public function setIr($pValue)
	{
		$this->ir = $pValue;
	}

	public function getIr()
	{
		return $this->ir;
	}

	public function setPis($pValue)
	{
		$this->pis = $pValue;
	}

	public function getPis()
	{
		return $this->pis;
	}

	public function setCofins($pValue)
	{
		$this->cofins= $pValue;
	}

	public function getCofins()
	{
		return $this->cofins;
	}

	public function setCsll($pValue)
	{
		$this->csll = $pValue;
	}

	public function getCsll()
	{
		return $this->csll;
	}

	public function setInss($pValue)
	{
		$this->inss = $pValue;
	}

	public function getInss()
	{
		return $this->inss;
	}

	public function setJuros($pValue)
	{
		$this->juros = $pValue;
	}

	public function getJuros()
	{
		return $this->juros;
	}

	public function setIss($pValue)
	{
		$this->iss = $pValue;
	}

	public function getIss()
	{
		return $this->iss;
	}

	public function setMulta($pValue)
	{
		$this->multa = $pValue;
	}

	public function getMulta()
	{
		return $this->multa;
	}

	public function setDesconto($pValue)
	{
		$this->desconto = $pValue;
	}

	public function getDesconto()
	{
		return $this->desconto;
	}

	public function setDtPagamento($pValue)
	{
		$this->dtPagamento = $pValue;
	}

	public function getDtPagamento()
	{
		return $this->dtPagamento;
	}
	
	public function setCheque($pValue)
	{
		$this->cheque = $pValue;
	}

	public function getCheque()
	{
		return $this->cheque;
	}
	
	public function setBaixadoem($pValue)
	{
		$this->baixadoem = $pValue;
	}

	public function getBaixadoem()
	{
		return $this->baixadoem;
	}

	//Constructor
	public function __construct()
	{
		$this->conn = new ConnectionFactory();
	}

	//Functions
	public function fillAttributes($row)
	{
		$this->setId($row['Id']);
		$this->setBanco($row['Banco']);
		$this->setFornecedor($row['Fornecedor']);
		$this->setCliente($row['Cliente']);
		$this->setPasta($row['Pasta']);
		$this->setFormaPagamento($row['FormaPagamento']);
		$this->setEmissao($row['Emissao']);
		$this->setVencimento($row['Vencimento']);
		$this->setNumFatura($row['NumFatura']);
		$this->setDetalhe($row['Detalhe']);
		$this->setValor($row['Valor']);
		$this->setIr($row['Ir']);
		$this->setPis($row['Pis']);
		$this->setCofins($row['Cofins']);
		$this->setCsll($row['Csll']);
		$this->setInss($row['Inss']);
		$this->setJuros($row['Juros']);
		$this->setIss($row['Iss']);
		$this->setMulta($row['Multa']);
		$this->setDesconto($row['Desconto']);
		$this->setDtPagamento($row['DtPagamento']);
		$this->setCheque($row['Cheque']);
		$this->setBaixadoem($row['Baixadoem']);
	}

	public function load($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_pagamentos_2 WHERE Id = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}

	public function save()
	{
		try
		{
			if($this->id  > 0)
			{
				return $this->update();
			}
			else
			{
				return $this->insert();
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function insert()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Banco',$this->getBanco(),'number'));
			array_push($fields, MySQLAux::CreateField('Fornecedor',$this->getFornecedor(),'number'));
			array_push($fields, MySQLAux::CreateField('Cliente',$this->getCliente(),'number'));
			array_push($fields, MySQLAux::CreateField('Pasta',$this->getPasta(),'number'));
			array_push($fields, MySQLAux::CreateField('FormaPagamento',$this->getFormaPagamento(),'number'));
			array_push($fields, MySQLAux::CreateField('Emissao',$this->getEmissao(),'datetime'));
			array_push($fields, MySQLAux::CreateField('Vencimento',$this->getVencimento(),'datetime'));
			array_push($fields, MySQLAux::CreateField('NumFatura',$this->getNumFatura(),'text'));
			array_push($fields, MySQLAux::CreateField('detalhe',$this->getDetalhe(),'text'));
			array_push($fields, MySQLAux::CreateField('Valor',$this->getValor(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Ir',$this->getIr(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Pis',$this->getPis(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Cofins',$this->getCofins(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Csll',$this->getCsll(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Inss',$this->getInss(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Juros',$this->getJuros(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Iss',$this->getIss(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Multa',$this->getMulta(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Desconto',$this->getDesconto(),'decimal'));
			array_push($fields, MySQLAux::CreateField('DtPagamento',$this->getDtPagamento(),'datetime'));
			array_push($fields, MySQLAux::CreateField('Cheque',$this->getCheque(),'text'));
			$this->id = $this->conn->ExecuteInsert(MySQLQuery::Insert('mfin_pagamentos_2',$fields));
			$success = $this->id > 0;

			return ($success);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function update()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Banco',$this->getBanco(),'number'));
			array_push($fields, MySQLAux::CreateField('Fornecedor',$this->getFornecedor(),'number'));
			array_push($fields, MySQLAux::CreateField('Cliente',$this->getCliente(),'number'));
			array_push($fields, MySQLAux::CreateField('Pasta',$this->getPasta(),'number'));
			array_push($fields, MySQLAux::CreateField('FormaPagamento',$this->getFormaPagamento(),'number'));
			array_push($fields, MySQLAux::CreateField('Emissao',$this->getEmissao(),'datetime'));
			array_push($fields, MySQLAux::CreateField('Vencimento',$this->getVencimento(),'datetime'));
			array_push($fields, MySQLAux::CreateField('NumFatura',$this->getNumFatura(),'text'));
			array_push($fields, MySQLAux::CreateField('detalhe',$this->getDetalhe(),'text'));
			array_push($fields, MySQLAux::CreateField('Valor',$this->getValor(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Ir',$this->getIr(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Pis',$this->getPis(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Cofins',$this->getCofins(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Csll',$this->getCsll(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Inss',$this->getInss(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Juros',$this->getJuros(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Iss',$this->getIss(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Multa',$this->getMulta(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Desconto',$this->getDesconto(),'decimal'));
			array_push($fields, MySQLAux::CreateField('DtPagamento',$this->getDtPagamento(),'datetime'));
			array_push($fields, MySQLAux::CreateField('Cheque',$this->getCheque(),'text'));
			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_pagamentos_2',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{

			echo($err);
			return false;
		}
	}
	
	public function updateBaixas()
	{
		try
		{
			$aux = new MySQLAux();
			$fields = array();
			array_push($fields, MySQLAux::CreateField('FormaPagamento',$this->getFormaPagamento(),'number'));
			array_push($fields, MySQLAux::CreateField('DtPagamento',$this->getDtPagamento(),'datetime'));
			array_push($fields, MySQLAux::CreateField('Cheque',$this->getCheque(),'text'));
			array_push($fields, MySQLAux::CreateField('Baixadoem',$this->getBaixadoem(),'datetime'));
			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_pagamentos_2',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{

			echo($err);
			return false;
		}
	}
	
	public function updateBaixasRemove()
	{
		try
		{
			$aux = new MySQLAux();
			$fields = array();
			array_push($fields, MySQLAux::CreateField('DtPagamento','NULL','null'));
			array_push($fields, MySQLAux::CreateField('Cheque','','text'));
			array_push($fields, MySQLAux::CreateField('Baixadoem','NULL','null'));
			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_pagamentos_2',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{

			echo($err);
			return false;
		}
	}

	public function delete()
	{
		try
		{
			return ($this->conn->ExecuteAffected("DELETE FROM mfin_pagamentos_2 WHERE Id = $this->id") > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function listAll()
	{
		return self::GenericList('SELECT * FROM mfin_pagamentos_2 ORDER BY Id ASC');
	}
	
	public function listAllBaixados()
	{
		return self::GenericList("SELECT * FROM mfin_pagamentos_2 WHERE Baixadoem IS NOT NULL ORDER BY Baixadoem DESC");
	}
	
	public function listAllParaBaixar()
	{
		return self::GenericList("SELECT * FROM mfin_pagamentos_2 WHERE Baixadoem IS NULL ORDER BY Id ASC");
	}

	public function GenericList($pQuery)
	{
		$result = $this->conn->ExecuteSelect($pQuery);
		$list = array();
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH))
			{
				$item = new PagamentosModel();
				$item->fillAttributes($row);
				array_push($list, $item);
			}
		}	
		return $list;
	}
}
