<?php
//USING
require_once '../Database/MySQL.Connection.php';
include_once('../Database/MySQL.Query.php');
include_once('../Database/MySQL.Aux.php');

/**
 * LoginModel
 *
 * Essa classe controla as propriedades e requisies do banco de dados dos usurios
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */

class RecebimentosModel
{
	//Attributes
	protected $id;
	protected $cliente;
	protected $pasta;
	protected $tipo;
	protected $forma;
	protected $banco;
	protected $numeroNota;
	protected $emissao;
	protected $vencimento;
	protected $juros;
	protected $multa;
	protected $desconto;
	protected $detalhe;
	protected $valor;
	protected $recebimento;
	protected $cheque;
	protected $baixadoem;
	protected $conn;

	public function setId($pValue)
	{
		$this->id = $pValue;
	}
	
	public function getId()
	{
		return $this->id;
	}

	public function setCliente($pValue)
	{
		$this->cliente = $pValue;
	}

	public function getCliente()
	{
		return $this->cliente;
	}

	public function setPasta($pValue)
	{
		$this->pasta = $pValue;
	}

	public function getPasta()
	{
		return $this->pasta;
	}

	public function setTipo($pValue)
	{
		$this->tipo = $pValue;
	}

	public function getTipo()
	{
		return $this->tipo;
	}

	public function setForma($pValue)
	{
		$this->forma = $pValue;
	}

	public function getForma()
	{
		return $this->forma;
	}

	public function setBanco($pValue)
	{
		$this->banco = $pValue;
	}

	public function getBanco()
	{
		return $this->banco;
	}

	public function setNumeroNota($pValue)
	{
		$this->numeroNota = $pValue;
	}

	public function getNumeroNota()
	{
		return $this->numeroNota;
	}

	public function setEmissao($pValue)
	{
		$this->emissao = $pValue;
	}

	public function getEmissao()
	{
		return $this->emissao;
	}

	public function setVencimento($pValue)
	{
		$this->vencimento = $pValue;
	}

	public function getVencimento()
	{
		return $this->vencimento;
	}

	public function setJuros($pValue)
	{
		$this->juros = $pValue;
	}

	public function getJuros()
	{
		return $this->juros;
	}

	public function setMulta($pValue)
	{
		$this->multa = $pValue;
	}

	public function getMulta()
	{
		return $this->multa;
	}

	public function setDesconto($pValue)
	{
		$this->desconto = $pValue;
	}

	public function getDesconto()
	{
		return $this->desconto;
	}

	public function setDetalhe($pValue)
	{
		$this->detalhe = $pValue;
	}

	public function getDetalhe()
	{
		return $this->detalhe;
	}

	public function setValor($pValue)
	{
		$this->valor = $pValue;
	}

	public function getValor()
	{
		return $this->valor;
	}

	public function setDtRecebimento($pValue)
	{
		$this->recebimento = $pValue;
	}

	public function getDtRecebimento()
	{
		return $this->recebimento;
	}
	
	public function setCheque($pValue)
	{
		$this->cheque = $pValue;
	}

	public function getCheque()
	{
		return $this->cheque;
	}

	public function setBaixadoem($pValue)
	{
		$this->baixadoem = $pValue;
	}

	public function getBaixadoem()
	{
		return $this->baixadoem;
	}

	//Constructor
	public function __construct()
	{
		$this->conn = new ConnectionFactory();
	}

	//Functions
	public function fillAttributes($row)
	{
		$this->setId($row['Id']);
		$this->setCliente($row['Cliente_Id']);
		$this->setPasta($row['Pasta_Id']);
		$this->setTipo($row['Tipo']);
		$this->setForma($row['Forma']);
		$this->setBanco($row['Banco_Id']);
		$this->setNumeroNota($row['NumeroNota']);
		$this->setEmissao($row['Emissao']);
		$this->setVencimento($row['Vencimento']);
		$this->setJuros($row['Juros']);
		$this->setMulta($row['Multa']);
		$this->setDesconto($row['Desconto']);
		$this->setDetalhe($row['Detalhe']);
		$this->setValor($row['Valor']);
		$this->setDtRecebimento($row['Recebimento']);
		$this->setCheque($row['Cheque']);
		$this->setBaixadoem($row['Baixadoem']);
	}

	public function load($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_recebimentos WHERE Id = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}

	public function save()
	{
		try
		{
			if($this->id  > 0)
			{
				return $this->update();
			}
			else
			{
				return $this->insert();
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function insert()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Cliente_Id',$this->getCliente(),'text'));
			array_push($fields, MySQLAux::CreateField('Pasta_Id',$this->getPasta(),'text'));
			array_push($fields, MySQLAux::CreateField('Tipo',$this->getTipo(),'text'));
			array_push($fields, MySQLAux::CreateField('Forma',$this->getForma(),'text'));
			array_push($fields, MySQLAux::CreateField('Banco_Id',$this->getBanco(),'text'));
			array_push($fields, MySQLAux::CreateField('NumeroNota',$this->getNumeroNota(),'text'));
			array_push($fields, MySQLAux::CreateField('Emissao',$this->getEmissao(),'datetime'));
			array_push($fields, MySQLAux::CreateField('Vencimento',$this->getVencimento(),'datetime'));
			array_push($fields, MySQLAux::CreateField('Juros',$this->getJuros(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Multa',$this->getMulta(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Desconto',$this->getDesconto(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Detalhe',$this->getDetalhe(),'text'));
			array_push($fields, MySQLAux::CreateField('Valor',$this->getValor(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Recebimento',$this->getDtRecebimento(),'datetime'));
			array_push($fields, MySQLAux::CreateField('Cheque',$this->getCheque(),'text'));
			$this->id = $this->conn->ExecuteInsert(MySQLQuery::Insert('mfin_recebimentos',$fields));
			$success = $this->id > 0;

			return ($success);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function update()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Cliente_Id',$this->getCliente(),'text'));
			array_push($fields, MySQLAux::CreateField('Pasta_Id',$this->getPasta(),'text'));
			array_push($fields, MySQLAux::CreateField('Tipo',$this->getTipo(),'text'));
			array_push($fields, MySQLAux::CreateField('Forma',$this->getForma(),'text'));
			array_push($fields, MySQLAux::CreateField('Banco_Id',$this->getBanco(),'text'));
			array_push($fields, MySQLAux::CreateField('NumeroNota',$this->getNumeroNota(),'text'));
			array_push($fields, MySQLAux::CreateField('Emissao',$this->getEmissao(),'datetime'));
			array_push($fields, MySQLAux::CreateField('Vencimento',$this->getVencimento(),'datetime'));
			array_push($fields, MySQLAux::CreateField('Juros',$this->getJuros(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Multa',$this->getMulta(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Desconto',$this->getDesconto(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Detalhe',$this->getDetalhe(),'text'));
			array_push($fields, MySQLAux::CreateField('Valor',$this->getValor(),'decimal'));
			array_push($fields, MySQLAux::CreateField('Recebimento',$this->getDtRecebimento(),'datetime'));
			array_push($fields, MySQLAux::CreateField('Cheque',$this->getCheque(),'text'));
			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_recebimentos',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{

			echo($err);
			return false;
		}
	}

	public function updateBaixas()
	{
		try
		{
			$aux = new MySQLAux();
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Forma',$this->getForma(),'number'));
			array_push($fields, MySQLAux::CreateField('Recebimento',$this->getDtRecebimento(),'datetime'));
			array_push($fields, MySQLAux::CreateField('Cheque',$this->getCheque(),'text'));
			array_push($fields, MySQLAux::CreateField('Baixadoem',$this->getBaixadoem(),'datetime'));
			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_recebimentos',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{

			echo($err);
			return false;
		}
	}
	
	public function updateBaixasRemove()
	{
		try
		{
			$aux = new MySQLAux();
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Recebimento','NULL','null'));
			array_push($fields, MySQLAux::CreateField('Cheque','','text'));
			array_push($fields, MySQLAux::CreateField('Baixadoem','NULL','null'));
			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_recebimentos',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{

			echo($err);
			return false;
		}
	}
	
	public function delete()
	{
		try
		{
			return ($this->conn->ExecuteAffected("DELETE FROM mfin_recebimentos WHERE Id = $this->id") > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function listAll()
	{
		return self::GenericList('SELECT * FROM mfin_recebimentos ORDER BY Id ASC');
	}

	public function listAllBaixados()
	{
		return self::GenericList("SELECT * FROM mfin_recebimentos WHERE Baixadoem IS NOT NULL ORDER BY Baixadoem DESC");
	}
	
	public function listAllParaBaixar()
	{
		return self::GenericList("SELECT * FROM mfin_recebimentos WHERE Baixadoem IS NULL ORDER BY Id ASC");
	}
	
	public function GenericList($pQuery)
	{
		$result = $this->conn->ExecuteSelect($pQuery);
		$list = array();
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH))
			{
				$item = new RecebimentosModel();
				$item->fillAttributes($row);
				array_push($list, $item);
			}
		}	
		return $list;
	}
}
