<?php
include_once('MySQL.Query.php');

class MySQLAux
{
	public function MySQLAux()
	{
		
	}
	
	public function DBDateNow()
	{
		return date('Y-m-d H:i:s');
	}
	
	public function CreateField($pName, $pValue, $pType)
	{
		$field = new MySQLField();
		$field->Set($pName, $pValue, $pType);
		
		return $field;
	}
	
	public function RetiraCaracteres($value)
	{
		$retorno = str_replace('.', '', $value);
		$retorno = str_replace('-', '', $retorno);
		$retorno = str_replace('/', '', $retorno);
		
		return $retorno;
	}
	
	public function LoadCPFMask($value)
	{
		if (!empty($value))
		{
			$retorno = substr_replace($value, '.', 3, 0);
			$retorno = substr_replace($retorno, '.', 7, 0);
			$retorno = substr_replace($retorno, '-', 11, 0);
			
			return $retorno;
		} 
		else
		{
			return '';
		}
	}
	
	public function LoadCPNJMask($value)
	{
		if (!empty($value)) {
			
			$retorno = substr_replace($value, '.', 2, 0);
			$retorno = substr_replace($retorno, '.', 6, 0);
			$retorno = substr_replace($retorno, '/', 10, 0);
			$retorno = substr_replace($retorno, '-', 15, 0);	
			
			return $retorno;
			
		}
		else
		{
			return '';
		} 
	}
	
	public function getValorBR($valor)
	{
		return number_format($valor, 2, ',', '.');
	}
	
	public function getValorEN($valor)
	{
		$valor = str_replace('.', '', $valor);
		$valor = str_replace(',', '.', $valor);
		$valor = number_format($valor, 2); 
		return str_replace(',', '', $valor);;
	}
	
	public function FormataData($data)
	{
		if ($data != "")
		{
		$dataArray = explode('/', $data);
		
		$novaData = $dataArray[2] .'-'. $dataArray[1] .'-'. $dataArray[0] .' 00:00:00';
		
		return $novaData;
		}
		else 
		{
			return '';
		}
	}
	
	public function getDataBR($data)
	{	
		if($data == '')
		{
			return '';
		}
		else 
		{
			return date("d/m/Y", strtotime($data));
		}
	}
}

?>