<?php
//We've included ../Includes/FusionCharts.php and ../Includes/DBConn.php, which contains
//functions to help us easily embed the charts and connect to a database.
include("../Includes/FusionCharts.php");
include("../Includes/DBConn.php");
?>
<HTML>
<HEAD>	
	<TITLE>
	FusionCharts - Database + JavaScript Example
	</TITLE>
	
	<?php
	//In this example, we show a combination of database + JavaScript (dataURL method)
	//rendering using FusionCharts.
	
	//The entire app (page) can be summarized as under. This app shows the break-down
	//of factory wise output generated. In a pie chart, we first show the sum of quantity
	//generated by each factory. These pie slices, when clicked would show detailed date-wise
	//output of that factory. The detailed data would be dynamically pulled by the column
	//chart from another PHP page. There are no page refreshes required. Everything
	//is done on one single page.
	
	//The XML data for the pie chart is fully created in PHP at run-time. PHP interacts
	//with the database and creates the XML for this.
	//Now, for the column chart (date-wise output report), each time we need the data
	//we dynamically submit request to the server with the appropriate factoryId. The server
	//responds with an XML document, which we accept and update chart at client side.
	?>	
	<SCRIPT LANGUAGE="Javascript" SRC="../../FusionCharts/FusionCharts.js">
		//You need to include the above JS file, if you intend to embed the chart using JavaScript.
		//Embedding using JavaScripts avoids the "Click to Activate..." issue in Internet Explorer
		//When you make your own charts, make sure that the path to this JS file is correct. Else, you would get JavaScript errors.
	</SCRIPT>
	
	<SCRIPT LANGUAGE="JavaScript">
		
		/** 
		 * updateChart method is invoked when the user clicks on a pie slice.
		 * In this method, we get the index of the factory after which we request for XML data
		 * for that that factory from FactoryData.php, and finally
		 * update the Column Chart.
		 *	@param	factoryIndex	Sequential Index of the factory.
		*/		
		function updateChart(factoryIndex){		
			//DataURL for the chart
			var strURL = "FactoryData.php?factoryId=" + factoryIndex;

			//Sometimes, the above URL and XML data gets cached by the browser.
			//If you want your charts to get new XML data on each request,
			//you can add the following line:
			//strURL = strURL + "&currTime=" + getTimeForURL();
			//getTimeForURL method is defined below and needs to be included
			//This basically adds a ever-changing parameter which bluffs
			//the browser and forces it to re-load the XML data every time.
						
			//URLEncode it - NECESSARY.
			strURL = escape(strURL);
			
			//Get reference to chart object using Dom ID "FactoryDetailed"
			var chartObj = getChartFromId("FactoryDetailed");			
			//Send request for XML
			chartObj.setDataURL(strURL);
		}
		/**
		 * getTimeForURL method returns the current time 
		 * in a URL friendly format, so that it can be appended to
		 * dataURL for effective non-caching.
		*/
		function getTimeForURL(){
			var dt = new Date();
			var strOutput = "";
			strOutput = dt.getHours() + "_" + dt.getMinutes() + "_" + dt.getSeconds() + "_" + dt.getMilliseconds();
			return strOutput;
		}
	</SCRIPT>
	<style type="text/css">
	<!--
	body {
		font-family: Arial, Helvetica, sans-serif;
		font-size: 12px;
	}
	.text{
		font-family: Arial, Helvetica, sans-serif;
		font-size: 12px;
	}
	-->
	</style>
</HEAD>
	
<BODY>

<CENTER>
<h2>FusionCharts Database + JavaScript (dataURL method) Example</h2>
<h4>Inter-connected charts - Click on any pie slice to see detailed chart below.</h4>
<p>The charts in this page have been dynamically generated using data contained in a database.</p>
<?php		

    //strXML will be used to store the entire XML document generated
    //Generate the chart element
    $strXML = "<chart caption='Factory Output report' subCaption='By Quantity' pieSliceDepth='30' showBorder='1' formatNumberScale='0' numberSuffix=' Units' >"	;

    // Connect to the DB
    $link = connectToDB();

    // Fetch all factory records
    $strQuery = "select * from Factory_Master";
    $result = mysql_query($strQuery) or die(mysql_error()); 

    //Iterate through each factory
    if ($result) {
        while($ors = mysql_fetch_array($result)) {
            //Now create a second query to get details for this factory
            $strQuery = "select FactoryId, sum(Quantity) as TotOutput from Factory_Output where FactoryId=" . $ors['FactoryId'] . " Group By FactoryId";
            $result2 = mysql_query($strQuery) or die(mysql_error());
            $ors2 = mysql_fetch_array($result2);
            //Generate <set label='..' value='..' link='..' />
            //Note that we're setting link as updateChart(factoryIndex) - JS Function
            $strXML .= "<set label='" . $ors['FactoryName'] . "' value='" . $ors2['TotOutput'] . "' link='javaScript:updateChart(" . $ors['FactoryId'] . ")'/>";
            //free the resultset
            mysql_free_result($result2);
        }
    }
    mysql_close($link);

    //Finally, close <chart> element
    $strXML .= "</chart>";

    //Create the chart - Pie 3D Chart with data from strXML
    echo renderChart("../../FusionCharts/Pie3D.swf", "", $strXML, "FactorySum", 500, 250, false, false);
?>
	<BR>
<?php
	//Column 2D Chart with changed "No data to display" message
	//We initialize the chart with <chart></chart>
	echo renderChart("../../FusionCharts/Column2D.swf?ChartNoDataText=Please select a factory from pie chart above to view detailed data.", "", "<chart></chart>", "FactoryDetailed", 600, 250, false, false);
?>
<BR><BR>
<a href='../NoChart.html' target="_blank">Unable to see the charts above?</a>
</CENTER>
</BODY>
</HTML>