Imports System
Imports System.Collections
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Web
Imports System.Web.SessionState
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.HtmlControls
Imports System.Data.Odbc

Namespace InfoSoftGlobal.GeneralPages.ASP.NET.DB_JS

    ''' <summary>
    ''' Summary description for _Default.
    ''' </summary>
    Public Class _Default
        Inherits System.Web.UI.Page

        Protected LiteralChart As System.Web.UI.WebControls.Literal

        ''' <summary>
        ''' The following string will contain the JS Data and variables.
        '''    This string will be built in ASP.NET and rendered at run-time as JavaScript.
        ''' </summary>
        Public jsVarString As String = String.Empty

        Private Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs)

        End Sub

        Public Function GetFactorySummayChartHtml() As String
            'In this example, we show a combination of database + JavaScript rendering using FusionCharts.
            'The entire app (page) can be summarized as under. This app shows the break-down
            'of factory wise output generated. In a pie chart, we first show the sum of quantity
            'generated by each factory. These pie slices, when clicked would show detailed date-wise
            'output of that factory.
            'The XML data for the pie chart is fully created in ASP.NET at run-time. ASP interacts
            'with the database and creates the XML for this.
            'Now, for the column chart (date-wise output report), we do not submit request to the server.
            'Instead we store the data for the factories in JavaScript arrays. These JavaScript
            'arrays are rendered by our ASP.NET Code (at run-time). We also have a few defined JavaScript
            'functions which react to the click event of pie slice.
            'We've used an Access database which is present in ../DB/FactoryDB.mdb. 
            'It just contains two tables, which are linked to each other. 
            'Before the page is rendered, we need to connect to the database and get the
            'data, as we'll need to convert this data into JavaScript variables.
            'Database Objects
            Dim factoryQuery As String = "select * from Factory_Master"
            Dim indexCount As Integer
            'Initialize the Pie chart with sum of production for each of the factories
            'xmlData will be used to store the entire XML document generated
            Dim xmlData As String
            Dim connection As OdbcConnection = DbHelper.Connection(DbHelper.ConnectionStringFactory)
            Dim factoryCommand As OdbcCommand = New OdbcCommand(factoryQuery, connection)
            Dim factoryAdapter As OdbcDataAdapter = New OdbcDataAdapter(factoryCommand)
            Dim factoryTable As DataTable = New DataTable
            factoryAdapter.Fill(factoryTable)
            'Initialize Index
            indexCount = 0
            'Generate the chart element
            xmlData = "<chart caption='Factory Output report' subCaption='By Quantity' pieSliceDepth='30' showBorder='1' for" & _
            "matNumberScale='0' numberSuffix=' Units' >"
            For Each row As DataRow In factoryTable.Rows
                indexCount = (indexCount + 1)
                Dim quantityQuery As String = ("select sum(Quantity) as TotOutput from Factory_Output where FactoryId=" & row("FactoryId"))
                Dim quantityCommand As OdbcCommand = New OdbcCommand(quantityQuery, connection)
                xmlData = (xmlData & ("<set label='" _
                            & (row("FactoryName") & ("' value='" _
                            & (quantityCommand.ExecuteScalar.ToString & ("' link='javaScript:updateChart(" _
                            & (indexCount.ToString & ")'/>")))))))
            Next
            connection.Close()
            xmlData = (xmlData & "</chart>")            
            'Create the chart - Pie 3D Chart with data from xmlData
            Return FusionCharts.RenderChart("../../FusionCharts/Pie3D.swf", "", xmlData, "FactorySum", "500", "250", False, True)            
        End Function

        Public Function GetFactoryDetailedChartHtml() As String            
            Return FusionCharts.RenderChart("../../FusionCharts/Column2D.swf?ChartNoDataText=Please select a factory from pie chart above to view " & _
                    "detailed data.", "", "<chart></chart>", "FactoryDetailed", "600", "250", False, True)
        End Function

        Public Function GetScript() As String
            'Iterate through each factory
            Dim factoryQuery As String = "select * from Factory_Master"
            Dim indexCount As Integer = 0
            Dim factoryTable As DataTable = New DataTable
            Dim connection As OdbcConnection = DbHelper.Connection(DbHelper.ConnectionStringFactory)
            Dim factoryCommand As OdbcCommand = New OdbcCommand(factoryQuery, connection)
            Dim factoryAdapter As OdbcDataAdapter = New OdbcDataAdapter(factoryCommand)
            factoryAdapter.Fill(factoryTable)
            For Each row As DataRow In factoryTable.Rows
                indexCount = (indexCount + 1)
                jsVarString = (jsVarString & ("" & vbTab & vbTab & " data[" _
                            & (indexCount.ToString & ("] = new Array();" & Environment.NewLine))))
                Dim outputQuery As String = ("select * from Factory_Output where FactoryId=" _
                            & (row("FactoryId").ToString & " order by DatePro Asc"))
                Dim outputCommand As OdbcCommand = New OdbcCommand(outputQuery, connection)
                Dim outputAdapter As OdbcDataAdapter = New OdbcDataAdapter(outputCommand)
                Dim outputTable As DataTable = New DataTable
                outputAdapter.Fill(outputTable)
                For Each outputRow As DataRow In outputTable.Rows
                    jsVarString = (jsVarString & ("" & vbTab & vbTab & " data[" _
                                & (indexCount.ToString & ("].push(new Array('" _
                                & (CType(outputRow("DatePro"), DateTime).Day.ToString & ("/" _
                                & (CType(outputRow("DatePro"), DateTime).Month.ToString & ("'," _
                                & (outputRow("Quantity").ToString & ("));" & Environment.NewLine))))))))))
                Next
            Next
            Return jsVarString
        End Function

        Protected Overrides Sub OnInit(ByVal e As EventArgs)
            '
            ' CODEGEN: This call is required by the ASP.NET Web Form Designer.
            '
            InitializeComponent()
            MyBase.OnInit(e)
        End Sub

        ''' <summary>
        ''' Required method for Designer support - do not modify
        ''' the contents of this method with the code editor.
        ''' </summary>
        Private Sub InitializeComponent()
            AddHandler Load, AddressOf Me.Page_Load
        End Sub
    End Class
End Namespace