<?php

/**
 * PHPExcel
 *
 * Copyright (C) 2006 - 2013 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2013 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    1.7.9, 2013-06-02
 */

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
//date_default_timezone_set('Europe/London');

if (PHP_SAPI == 'cli')
	die('This example should only be run from a Web Browser');

/** Include PHPExcel */
require_once '../Classes/PHPExcel.php';
require_once('../../Connections/arvores.php');
session_start();
//Validacao de login
if( !isset($_SESSION['username'])){
		header("Location: error.php" );
	}
	
	


//Query
mysql_select_db($database_arvores, $arvores);
$query_recebimento = "SELECT DATE_FORMAT(rec_data_emissao, '%d/%m/%Y') as rec_dat_emissao, DATE_FORMAT(rec_data_vencimento, '%d/%m/%Y') as rec_dat_vencimento, DATE_FORMAT(rec_data_pagamento, '%d/%m/%Y') as rec_dat_recebimento, rec_parcelamento_ini, rec_parcelamento_fim, rec_nota_fiscal, rec_valor, rec_desconto, rec_multa, rec_pis, rec_cofins, rec_iss, rec_csll, rec_ir, rec_outro, rec_detalhe, banco_id, banco_nome, banco_numero, banco_agencia, banco_agencia_dig, banco_conta, banco_conta_dig, banco_detalhe, banco_padrao, banco_ativo, periodicidade_id, periodicidade_nome, forma_id, forma_nome, cliente_id, cliente_nome, cliente_cnpj, conta_id, conta_nome, ccusto_id, ccusto_nome, ccusto_grupo_id, ccusto_grupo_nome, conta_grupo_id, conta_grupo_nome
FROM recebimento  
Inner JOIN banco ON id_banco=banco_id  
Inner JOIN periodicidade ON id_periodicidade=periodicidade_id  
Inner JOIN forma ON id_forma=forma_id  
Inner JOIN cliente ON id_cliente=cliente_id 
Inner JOIN conta ON id_conta=conta_id  
Inner JOIN ccusto ON id_ccusto=ccusto_id
Inner JOIN ccusto_grupo ON id_ccusto_grupo=ccusto_grupo_id 
Inner JOIN conta_grupo ON id_conta_grupo=conta_grupo_id  
WHERE rec_ativo = 1 ".$_SESSION['criterio']." ORDER BY rec_data_emissao ASC";
$recebimento = mysql_query($query_recebimento, $arvores) or die(mysql_error());
$row_recebimento = mysql_fetch_assoc($recebimento);
$totalRows_recebimento = mysql_num_rows($recebimento);
$totalFields_recebimento = mysql_num_fields ($recebimento);
$linha = 0;
$coluna = 65;
$coluna_2 = 00;
$linha = 1;



// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set document properties
$objPHPExcel->getProperties()->setCreator("Arvoros Sistemas inteligentes")
							 ->setLastModifiedBy("Arvoros Sistemas inteligentes")
							 ->setTitle("Arvoros Sistemas inteligentes")
							 ->setSubject("Arvoros Sistemas inteligentes")
							 ->setDescription("Arvoros Sistemas inteligentes")
							 ->setKeywords("office 2007 openxml php")
							 ->setCategory("Arvoros Sistemas inteligentes");

// Add some data
$objPHPExcel->setActiveSheetIndex(0);
//Titulos			
foreach (array_keys($row_recebimento) as $value) {
		
	//Verificando colunas
	if($coluna >90){
		$coluna = 65;
		if($coluna_2 >= 65){
			$coluna_2++;
		}else{
			$coluna_2=65;
		}
	}
	
	//Variavel com a Coluna
	if($coluna_2 >=65){
		$coluna_nome = chr($coluna_2).chr($coluna);	
	}else{
		$coluna_nome = chr($coluna);	
	}
	//Adicionando Proxima Coluna
	$coluna++;
	

	$objPHPExcel->getActiveSheet()->SetCellValue($coluna_nome.$linha, utf8_encode($value));
	
}


//Proxima Linha e Reset Coluna
	$linha++;
	$coluna = 65;
	$coluna_2 = 00;

//DADOS
do {

	foreach (array_keys($row_recebimento) as $value) {
		
		//Verificando colunas
		if($coluna >90){
			$coluna = 65;
			if($coluna_2 >= 65){
				$coluna_2++;
			}else{
				$coluna_2=65;
			}
		}
		
		//Variavel com a Coluna
		if($coluna_2 >=65){
			$coluna_nome = chr($coluna_2).chr($coluna);	
		}else{
			$coluna_nome = chr($coluna);	
		}
	
		//Adicionando Proxima Coluna
		$coluna++;
		$objPHPExcel->getActiveSheet()->SetCellValue($coluna_nome.$linha, utf8_encode($row_recebimento[$value]));
	}
	
	//Proxima Linha e Reset Coluna
	$linha++;
	$coluna = 65;
	$coluna_2 = 00;
	

} while ($row_recebimento = mysql_fetch_assoc($recebimento));


// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('export');


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);


// Redirect output to a client’s web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="export.xlsx"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
exit;