<?php

//USING
require_once 'controls/verifylogin.php';
require_once '../Class/model/FormasPagamentosModel.php';
require_once '../Class/model/PagamentosModel.php';
require_once '../Class/controller/BaixaPagamentosControl.php';
include_once('../Database/MySQL.Aux.php');

$control = new BaixaPagamentosControl();
$model = new PagamentosModel();
$aux = new MySQLAux();

$control->setAction();
$control->setId();

$action = $control->getAction();
$id = $control->getId();

//LoadDados
if ($id > 0)
{
	$model->load($id);
}

if($action == 'save')
{	
    try
    {   
	    foreach($_POST['check_list'] as $check) { 	
	    		$control->GetData($check);
	    }
		header( 'Location: baixapagamentos.php' );
	}
	catch(Exception $err)
	{
		echo "<script>alert('Ocorreu um problema ao salvar o registro.');</script>";
	}
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>

<title>Mdulo Financeiro</title>

<?php include_once('controls/import.php'); ?>
<script src="js/baixapagamentos.js" type="text/javascript"></script>

</head>
<body>

<?php include_once('controls/header.php'); ?>

<div class="content">

<div class="form"><?php include_once('controls/menu.php'); ?>

<div id="conteudo-site">

<div class="titulo-conteudo-site"><img src="images/applications.png"
	title="" alt="" /> Baixar os pagamentos</div>

<form id="frmRegister" method="post" action=""><input type="hidden"
	id="hdnAction" name="action" value="save" />

<table border="0" cellpadding="3" cellspacing="0" class="tblGeral"
	width="100%">
	<tr>
		<td><span class="title">Data da baixa:</span></td>
		<td><input type="text" id="databaixa" name="databaixa"
			class="content-data" style="width: 100px;"
			onkeyup="formataData(this,event);" maxlength="10" /> *</td>
	</tr>
	<tr>
		<td><span class="title">Forma de pagamento:</span></td>
		<td>
		<select id="forma" name="forma" class="content-data">
			<option value="">Selecione</option>
			<?php 
			
				$formaPagamento = new FormasPagamentosModel();
				
				foreach ($formaPagamento->listAll() as $item) {
				
					$select = '';
					if ($item->getId() == $model->getFormaPagamento())
					{
						$select = "selected='selected'";
					}
					
					echo "<option value='{$item->getId()}' {$select}>{$item->getNome()}</option>";
				}
			?>
		
		</select>*</td>
	</tr>
	<tr>
		<td><span class="title">Cheque:</span></td>
		<td><input type="text" id="cheque" name="cheque"
			class="content-data" style="width: 300px;" /> </td>
	</tr>
	<tr>
		<td colspan="2">

		<table border="0" cellpadding="3" cellspacing="0"
			class="gridPesquisa fundoGridPesquisa" width="100%">
			<tr>
				<th>Fornecedor</th>
				<th>N da Fatura</th>
				<th>Emisso</th>
				<th>Vencimento</th>
				<th>Valor</th>
				<th>Baixa 
				<br /><input type="checkbox" id="select_all"/></th>
			</tr>

			<?php

			foreach ($model->listAllParaBaixar() as $item) {

				echo "<tr>";
				echo "<td> {$control->RetornaFornecedor($item->getFornecedor())}  </td>";
				echo "<td> {$item->getNumFatura()} </td>";
				echo "<td> {$aux->getDataBR($item->getEmissao())} </td>";
				echo "<td> {$aux->getDataBR($item->getVencimento())} </td>";
				echo "<td> {$aux->getValorBR($control->RetornaValorTotal($item->getId()))} </td>";
				echo "<td> <input type='checkbox' name='check_list[]' value='{$item->getId()}'></td>";
				echo "</tr>";
			}

			?>
		</table>

		</td>
	</tr>
</table>

<div id="pBotoes" style="text-align: right"><span>&nbsp;</span> <br />
<input type="submit" name="btnSalvar" id="btnSalvar" class="submit"
	value="Baixar pagamentos selecionados" /> <input type="button" name="btnCancelar"
	class="submit" value="Cancelar"
	onclick="window. location.href='baixapagamentos.php'" /></div>

</form>

</div>

</div>

</div>

			<?php include_once('controls/footer.php'); ?>

</body>
</html>
