<?php

//USING
require_once 'controls/verifylogin.php';
require_once '../Class/model/EmpresasModel.php';
require_once '../Class/controller/EmpresasControl.php';
require_once '../Class/model/EstadoModel.php';
include_once('../Database/MySQL.Aux.php');

$control = new EmpresasControl();
$model = new EmpresasModel();
$aux = new MySQLAux();

$control->setAction();
$control->setId();

$action = $control->getAction();
$id = $control->getId();

//LoadDados
if ($id > 0)
{
	$model->load($id);
}

if($action == 'save')
{
	try
	{
		$control->GetData();
		header( 'Location: empresas.php' );
	}
	catch(Exception $err)
	{
		echo "<script>alert('Ocorreu um problema ao salvar o registro.');</script>";
	}
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>

<title>Mdulo Financeiro</title>

<?php include_once('controls/import.php'); ?>
<script src="js/empresas.js" type="text/javascript"></script>

</head>
<body>

<?php include_once('controls/header.php'); ?>

<div class="content">

<div class="form"><?php include_once('controls/menu.php'); ?>

<div id="conteudo-site">

<div class="titulo-conteudo-site"><img src="images/applications.png"
	title="" alt="" /> Cadastro de Empresas</div>

<form id="frmRegister" method="post" action=""><input type="hidden"
	id="hdnAction" name="action" value="save" /> <input type="hidden"
	id="hdnId" name="Id" value="<?php echo $model->getId();?>" />
	 <input type="hidden" id="cidade" name="cidade" value="<?php echo $model->getCidade();?>" />

<table border="0" cellpadding="3" cellspacing="0" class="tblGeral"
	width="100%">
	<tr>
		<td><span class="title">Nome:</span></td>
		<td><input type="text" id="nome" name="nome" class="content-data"
			style="width: 300px;" value="<?php echo $model->getNome();?>" /> *</td>
	</tr>
	<tr>
		<td><span class="title">CNPJ:</span></td>
		<td><input type="text" id="cnpj" name="cnpj" class="content-data"
			style="width: 130px;" maxlength="18"
			onkeyup="formataCNPJ(this,event);" value="<?php echo $aux->LoadCPNJMask($model->getCnpj());?>" /> *</td>
	</tr>
	<tr>
		<td><span class="title">Inscrio Municipal:</span></td>
		<td><input type="text" id="inscricaomunicipal" name="inscricaomunicipal" class="content-data"
			style="width: 190px;" value="<?php echo $model->getInscricaoMunicipal();?>" /></td>
	</tr>
	<tr>
		<td><span class="title">Crc:</span></td>
		<td><input type="text" id="crc" name="crc" class="content-data"
			style="width: 130px;" value="<?php echo $model->getCrc();?>" /></td>
	</tr>
	<tr>
		<td><span class="title">Cep:</span></td>
		<td><input type="text" id="cep" name="cep" class="content-data"
			style="width: 100px;" maxlength="9" onkeyup="formataCEP(this,event);" value="<?php echo $model->getCep();?>" /> *</td>
	</tr>
	<tr>
		<td><span class="title">Estado:</span></td>
		<td><select id="estados" name="estados" class="content-data">
			<option value="">Selecione</option>
			<?php

			$estado = new EstadoModel();

			foreach ($estado->listAll() as $item) {

				$select = '';
				if ($item->getId() == $model->getEstado())
				{
					$select = "selected='selected'";
				}
					
				echo "<option value='{$item->getId()}' {$select}>{$item->getSigla()}</option>";
			}

			?>

		</select> *</td>
	</tr>
	<tr>
		<td><span class="title">Cidade:</span></td>
		<td><select id="cidades" name="cidades" class="content-data">
			<option value="">-- Escolha um estado --</option>

		</select> <script type="text/javascript">
		
		$(document).ready(function(){
		    $('#estados').change(function(){
		        $('#cidades').load('cidades.php?estado='+$('#estados').val() );
		    });

		    if ($('#estados').val() != '')
		    {
		    	$('#cidades').load('cidades.php?estado='+$('#estados').val()+'&cidade='+$('#cidade').val() );
			}
		    
		});
		
		</script> *</td>
	</tr>
	<tr>
		<td><span class="title">Bairro:</span></td>
		<td><input type="text" id="bairro" name="bairro" class="content-data"
			style="width: 100px;" value="<?php echo $model->getBairro();?>" /></td>
	</tr>
	<tr>
		<td><span class="title">Endereo:</span></td>
		<td><input type="text" id="endereco" name="endereco" class="content-data"
			style="width: 300px;" value="<?php echo $model->getEndereco();?>" /> *</td>
	</tr>
	<tr>
		<td><span class="title">Nmero:</span></td>
		<td><input type="text" id="numero" name="numero" class="content-data"
			style="width: 30px;" maxlength="4" onkeyup="formataInteiro(this,event);" value="<?php echo $model->getNumero();?>" /> *</td>
	</tr>
	<tr>
		<td><span class="title">Complemento:</span></td>
		<td><input type="text" id="complemento" name="complemento" class="content-data"
			style="width: 190px;" value="<?php echo $model->getComplemento();?>" /></td>
	</tr>
	<tr>
		<td><span class="title">Telefone:</span></td>
		<td><input type="text" id="telefone" name="telefone" class="content-data"
			style="width: 85px;" maxlength="12"
			onkeyup="formataTelefone(this,event);" value="<?php echo $model->getTelefone();?>" /></td>
	</tr>
	<tr>
		<td><span class="title">Nmero do Banco:</span></td>
		<td><input type="text" id="banco" name="banco" class="content-data"
			style="width: 64px;" onkeyup="formataInteiro(this,event);" value="<?php echo $model->getBanco();?>" /> *</td>
	</tr>
	<tr>
		<td><span class="title">Agncia:</span></td>
		<td><input type="text" id="agencia" name="agencia" class="content-data"
			style="width: 60px;" value="<?php echo $model->getAgencia();?>" /> *</td>
	</tr>
	<tr>
		<td><span class="title">Conta Corrente:</span></td>
		<td><input type="text" id="contacorrente" name="contacorrente" class="content-data"
			style="width: 120px;" value="<?php echo $model->getContaCorrente();?>" /> *</td>
	</tr>
	<tr>
		<td><span class="title">E-mail</span></td>
		<td><input type="text" id="email" name="email" class="content-data"
			style="width: 300px;" value="<?php echo $model->getEmail();?>" /></td>
	</tr>
</table>

<div id="pBotoes" style="text-align: right"><span>&nbsp;</span> <br />
<input type="submit" id="btnSalvar" name="btnSalvar" class="submit" value="Salvar" /> <input
	type="button" name="btnCancelar" class="submit" value="Cancelar"
	onclick="window. location.href='empresas.php'" /></div>

</form>

</div>

</div>

</div>

			<?php include_once('controls/footer.php'); ?>

</body>
</html>
