<?php
//USING
require_once '../Class/model/PagamentosModel.php';
require_once '../Class/model/FornecedoresModel.php';
require_once '../Class/model/FormasPagamentosModel.php';
include_once('../Database/MySQL.Aux.php');

/**
 * BaixaPagamentosControl - Controle das baixas de pagamentos
 *
 * Essa classe controla as baixas de pagamentos
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */
class BaixaPagamentosControl
{
	protected $id;
	protected $action;
	protected $deletar;

	public function setId()
	{
		if (isset($_GET['id']))
		{
			$this->id = $_GET['id'];
		}
	}

	public function getId()
	{
		return $this->id;
	}

	public function setAction()
	{
		if (isset($_POST['action']))
		{
			$this->action = $_POST['action'];
		}
	}

	public function getAction()
	{
		return $this->action;
	}

	public function setDel()
	{
		if (isset($_GET['del']))
		{
			$this->deletar = $_GET['del'];
		}
	}

	public function getDel()
	{
		return $this->deletar;
	}

	//Constructor
	public function __construct()
	{

	}

	public function GetData($id)
	{
		$result = new PagamentosModel();
		$aux = new MySQLAux();
		
		$result->setId($id);
		$result->setFormaPagamento($_POST['forma']);
		$result->setDtPagamento($aux->FormataData($_POST['databaixa']));
		$result->setCheque($_POST['cheque']);
		$result->setBaixadoem($aux->DBDateNow());

		return $result->updateBaixas();
	}
	
	public function RetornaValorTotal($id)
	{
		$model = new PagamentosModel();
		$model->load($id);
		
		$totalDescontos = $model->getIr() + $model->getPis() + $model->getCofins() + $model->getCsll() + $model->getInss() + $model->getIss() + $model->getDesconto();
		$totalAcrescimos = $model->getJuros() + $model->getMulta();

		$totalDescontado = $model->getValor() - $totalDescontos;
		$total = $totalDescontado + $totalAcrescimos;

		return $total; 
	}
	
	public function RetornaFornecedor($id)
	{
		$result = new FornecedorModel();
		$result->load($id);
		return $result->getNomeFantasia();
	}
	
	public function RetornaFormaPagamento($id)
	{
		$result = new FormasPagamentosModel();
		$result->load($id);
		return $result->getNome();
	}
}

?>