<?php
//USING
require_once '../Class/model/PagamentosModel.php';
require_once '../Class/model/FornecedoresModel.php';
require_once '../Class/model/ClientesModel.php';
include_once('../Database/MySQL.Aux.php');

/**
 * BancosControl - Controle dos pagamentos do sistema
 *
 * Essa classe controla as requisicoes da classe Bancos
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */
class PagamentosControl
{
	protected $id;
	protected $action;
	protected $deletar;

	public function setId()
	{
		if (isset($_GET['id']))
		{
			$this->id = $_GET['id'];
		}
	}

	public function getId()
	{
		return $this->id;
	}

	public function setAction()
	{
		if (isset($_POST['action']))
		{
			$this->action = $_POST['action'];
		}
	}

	public function getAction()
	{
		return $this->action;
	}

	public function setDel()
	{
		if (isset($_GET['del']))
		{
			$this->deletar = $_GET['del'];
		}
	}

	public function getDel()
	{
		return $this->deletar;
	}

	//Constructor
	public function __construct()
	{

	}

	public function GetData()
	{
		$result = new PagamentosModel();
		$aux = new MySQLAux();
		
		$result->setId($_POST['Id']);
		$result->setBanco($_POST['banco']);
		$result->setFornecedor($_POST['fornecedor']);
		$result->setCliente($_POST['cliente']);
		$result->setPasta($_POST['pastas']);		
		$result->setFormaPagamento($_POST['formapagamento']);
		$result->setEmissao($aux->FormataData($_POST['emissao']));
		$result->setVencimento($aux->FormataData($_POST['vencimento']));
		$result->setNumFatura($_POST['numfatura']);
		$result->setDetalhe($_POST['detalhe']);
		$result->setValor($aux->getValorEN($_POST['valor']));
		$result->setIr($aux->getValorEN($_POST['ir']));
		$result->setPis($aux->getValorEN($_POST['pis']));
		$result->setCofins($aux->getValorEN($_POST['cofins']));
		$result->setCsll($aux->getValorEN($_POST['csll']));
		$result->setInss($aux->getValorEN($_POST['inss']));
		$result->setJuros($aux->getValorEN($_POST['juros']));
		$result->setIss($aux->getValorEN($_POST['iss']));
		$result->setMulta($aux->getValorEN($_POST['multa']));
		$result->setDesconto($aux->getValorEN($_POST['desconto']));
		$result->setDtPagamento($aux->FormataData($_POST['dtpagamento']));
		$result->setCheque($_POST['cheque']);

		return $result->save();
	}
	
	public function GetFornecedor($fornecedor)
	{
		$fornecedorModel = new FornecedorModel();
		$fornecedorModel->load($fornecedor);
		
		return $fornecedorModel->getNomeFantasia();
	}
	
	public function GetCliente($cliente)
	{
		$clientes = new ClientesModel();
		$clientes->load($cliente);
		
		return $clientes->getNomeFantasia();
	}
}

?>