<?php
//USING
require_once '../Database/MySQL.Connection.php';
include_once('../Database/MySQL.Query.php');
include_once('../Database/MySQL.Aux.php');

/**
 * LoginModel
 *
 * Essa classe controla as propriedades e requisies do banco de dados dos usurios
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */

class EmpresasModel
{
	//Attributes
	protected $id;
	protected $banco;
	protected $estado;
	protected $cidade;
	protected $nome;
	protected $cnpj;
	protected $inscricaoMunicipal;
	protected $crc;
	protected $cep;
	protected $bairro;
	protected $endereco;
	protected $numero;
	protected $complemento;
	protected $telefone;
	protected $agencia;
	protected $contaCorrente;
	protected $email;
	protected $conn;

	public function setId($pValue)
	{
		$this->id = $pValue;
	}

	public function getId()
	{
		return $this->id;
	}

	public function setBanco($pValue)
	{
		$this->banco = $pValue;
	}

	public function getBanco()
	{
		return $this->banco;
	}

	public function setEstado($pValue)
	{
		$this->estado = $pValue;
	}

	public function getEstado()
	{
		return $this->estado;
	}

	public function setCidade($pValue)
	{
		$this->cidade = $pValue;
	}

	public function getCidade()
	{
		return $this->cidade;
	}

	public function setNome($pValue)
	{
		$this->nome = $pValue;
	}

	public function getNome()
	{
		return $this->nome;
	}
	
	public function setCnpj($pValue)
	{
		$this->cnpj = $pValue;
	}

	public function getCnpj()
	{
		return $this->cnpj;
	}
	
	public function setInscricaoMunicipal($pValue)
	{
		$this->inscricaoMunicipal = $pValue;
	}

	public function getInscricaoMunicipal()
	{
		return $this->inscricaoMunicipal;
	}
	
	public function setCrc($pValue)
	{
		$this->crc = $pValue;
	}

	public function getCrc()
	{
		return $this->crc;
	}

	public function setCep($pValue)
	{
		$this->cep = $pValue;
	}

	public function getCep()
	{
		return $this->cep;
	}
	
	public function setBairro($pValue)
	{
		$this->bairro = $pValue;
	}

	public function getBairro()
	{
		return $this->bairro;
	}
	
	public function setEndereco($pValue)
	{
		$this->endereco = $pValue;
	}

	public function getEndereco()
	{
		return $this->endereco;
	}
	
	public function setNumero($pValue)
	{
		$this->numero = $pValue;
	}

	public function getNumero()
	{
		return $this->numero;
	}

	public function setComplemento($pValue)
	{
		$this->complemento = $pValue;
	}

	public function getComplemento()
	{
		return $this->complemento;
	}

	public function setTelefone($pValue)
	{
		$this->telefone = $pValue;
	}

	public function getTelefone()
	{
		return $this->telefone;
	}

	public function setAgencia($pValue)
	{
		$this->agencia = $pValue;
	}

	public function getAgencia()
	{
		return $this->agencia;
	}

	public function setContaCorrente($pValue)
	{
		$this->contaCorrente = $pValue;
	}

	public function getContaCorrente()
	{
		return $this->contaCorrente;
	}

	public function setEmail($pValue)
	{
		$this->email = $pValue;
	}

	public function getEmail()
	{
		return $this->email;
	}

	//Constructor
	public function __construct()
	{
		$this->conn = new ConnectionFactory();
	}

	//Functions
	public function fillAttributes($row)
	{
		$this->setId($row['Id']);
		$this->setBanco($row['Banco']);
		$this->setEstado($row['Estado']);
		$this->setCidade($row['Cidade']);
		$this->setNome($row['Nome']);
		$this->setCnpj($row['Cnpj']);
		$this->setInscricaoMunicipal($row['InscricaoMunicipal']);
		$this->setCrc($row['Crc']);
		$this->setCep($row['Cep']);
		$this->setBairro($row['Bairro']);
		$this->setEndereco($row['Endereco']);
		$this->setNumero($row['Numero']);
		$this->setComplemento($row['Complemento']);
		$this->setTelefone($row['Telefone']);
		$this->setAgencia($row['Agencia']);
		$this->setContaCorrente($row['ContaCorrente']);
		$this->setEmail($row['Email']);
	}

	public function load($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_empresas WHERE Id = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}

	public function save()
	{
		try
		{
			if($this->id > 0)
			{
				return $this->update();
			}
			else
			{
				return $this->insert();
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function insert()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Banco',$this->getBanco(),'text'));
			array_push($fields, MySQLAux::CreateField('Estado',$this->getEstado(),'text'));
			array_push($fields, MySQLAux::CreateField('Cidade',$this->getCidade(),'text'));
			array_push($fields, MySQLAux::CreateField('Nome',$this->getNome(),'text'));
			array_push($fields, MySQLAux::CreateField('Cnpj',$this->getCnpj(),'text'));
			array_push($fields, MySQLAux::CreateField('InscricaoMunicipal',$this->getInscricaoMunicipal(),'text'));
			array_push($fields, MySQLAux::CreateField('Crc',$this->getCrc(),'text'));
			array_push($fields, MySQLAux::CreateField('Cep',$this->getCep(),'text'));
			array_push($fields, MySQLAux::CreateField('Bairro',$this->getBairro(),'text'));
			array_push($fields, MySQLAux::CreateField('Endereco',$this->getEndereco(),'text'));
			array_push($fields, MySQLAux::CreateField('Numero',$this->getNumero(),'text')) ;
			array_push($fields, MySQLAux::CreateField('Complemento',$this->getComplemento(),'text'));
			array_push($fields, MySQLAux::CreateField('Telefone',$this->getTelefone(),'text'));
			array_push($fields, MySQLAux::CreateField('Agencia',$this->getAgencia(),'text'));
			array_push($fields, MySQLAux::CreateField('ContaCorrente',$this->getContaCorrente(),'text'));
			array_push($fields, MySQLAux::CreateField('Email',$this->getEmail(),'text'));
			$this->id = $this->conn->ExecuteInsert(MySQLQuery::Insert('mfin_empresas',$fields));
			$success = $this->id > 0;

			return ($success);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function update()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Banco',$this->getBanco(),'text'));
			array_push($fields, MySQLAux::CreateField('Estado',$this->getEstado(),'text'));
			array_push($fields, MySQLAux::CreateField('Cidade',$this->getCidade(),'text'));
			array_push($fields, MySQLAux::CreateField('Nome',$this->getNome(),'text'));
			array_push($fields, MySQLAux::CreateField('Cnpj',$this->getCnpj(),'text'));
			array_push($fields, MySQLAux::CreateField('InscricaoMunicipal',$this->getInscricaoMunicipal(),'text'));
			array_push($fields, MySQLAux::CreateField('Crc',$this->getCrc(),'text'));
			array_push($fields, MySQLAux::CreateField('Cep',$this->getCep(),'text'));
			array_push($fields, MySQLAux::CreateField('Bairro',$this->getBairro(),'text'));
			array_push($fields, MySQLAux::CreateField('Endereco',$this->getEndereco(),'text'));
			array_push($fields, MySQLAux::CreateField('Numero',$this->getNumero(),'text')) ;
			array_push($fields, MySQLAux::CreateField('Complemento',$this->getComplemento(),'text'));
			array_push($fields, MySQLAux::CreateField('Telefone',$this->getTelefone(),'text'));
			array_push($fields, MySQLAux::CreateField('Agencia',$this->getAgencia(),'text'));
			array_push($fields, MySQLAux::CreateField('ContaCorrente',$this->getContaCorrente(),'text'));
			array_push($fields, MySQLAux::CreateField('Email',$this->getEmail(),'text'));			
			
			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_empresas',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{

			echo($err);
			return false;
		}
	}

	public function delete()
	{
		try
		{
			return ($this->conn->ExecuteAffected("DELETE FROM mfin_empresas WHERE Id = $this->id") > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function listAll()
	{
		return self::GenericList('SELECT * FROM mfin_empresas ORDER BY Id ASC');
	}

	public function GenericList($pQuery)
	{
		$result = $this->conn->ExecuteSelect($pQuery);
		$list = array();
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH))
			{
				$item = new EmpresasModel();
				$item->fillAttributes($row);
				array_push($list, $item);
			}
		}	
		return $list;
	}
}
