<?php
//USING
require_once '../Database/MySQL.Connection.php';
include_once('../Database/MySQL.Query.php');
include_once('../Database/MySQL.Aux.php');

/**
 * LoginModel
 *
 * Essa classe controla as propriedades e requisies do banco de dados dos usurios
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */

class FormasPagamentosModel
{
	//Attributes
	protected $id;
	protected $nome;
	protected $status;
	protected $conn;

	public function setId($pValue)
	{
		$this->id = $pValue;
	}
	
	public function getId()
	{
		return $this->id;
	}

	public function setNome($pValue)
	{
		$this->nome = $pValue;
	}

	public function getNome()
	{
		return $this->nome;
	}

	public function setStatus($pValue)
	{
		$this->status = $pValue;
	}

	public function getStatus()
	{
		return $this->status;
	}


	//Constructor
	public function __construct()
	{
		$this->conn = new ConnectionFactory();
	}

	//Functions
	public function fillAttributes($row)
	{
		$this->setId($row['Id']);
		$this->setNome($row['Nome']);
		$this->setStatus($row['Status']);
	}

	public function load($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_formaspagamentos WHERE Id = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}

	public function save()
	{
		try
		{
			if($this->id  > 0)
			{
				return $this->update();
			}
			else
			{
				return $this->insert();
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function insert()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Nome',$this->getNome(),'text'));
			array_push($fields, MySQLAux::CreateField('Status',$this->getStatus(),'number'));
			$this->id = $this->conn->ExecuteInsert(MySQLQuery::Insert('mfin_formaspagamentos',$fields));
			$success = $this->id > 0;

			return ($success);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function update()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Nome',$this->getNome(),'text'));
			array_push($fields, MySQLAux::CreateField('Status',$this->getStatus(),'number'));

			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_formaspagamentos',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{

			echo($err);
			return false;
		}
	}

	public function delete()
	{
		try
		{
			return ($this->conn->ExecuteAffected("DELETE FROM mfin_formaspagamentos WHERE Id = $this->id") > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function listAll()
	{
		return self::GenericList('SELECT * FROM mfin_formaspagamentos ORDER BY Id ASC');
	}

	public function GenericList($pQuery)
	{
		$result = $this->conn->ExecuteSelect($pQuery);
		$list = array();
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH))
			{
				$item = new FormasPagamentosModel();
				$item->fillAttributes($row);
				array_push($list, $item);
			}
		}	
		return $list;
	}
}
