<?php
//USING
require_once '../Class/model/FornecedoresModel.php';
include_once('../Database/MySQL.Aux.php');

/**
 * BancosControl - Controle dos fornecedores
 *
 * Essa classe controla as requisicoes da classe Fornecedores
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */
class FornecedoresControl
{
	protected $id;
	protected $action;
	protected $deletar;

	public function setId()
	{
		if (isset($_GET['id']))
		{
			$this->id = $_GET['id'];
		}
	}

	public function getId()
	{
		return $this->id;
	}

	public function setAction()
	{
		if (isset($_POST['action']))
		{
			$this->action = $_POST['action'];
		}
	}

	public function getAction()
	{
		return $this->action;
	}

	public function setDel()
	{
		if (isset($_GET['del']))
		{
			$this->deletar = $_GET['del'];
		}
	}

	public function getDel()
	{
		return $this->deletar;
	}

	//Constructor
	public function __construct()
	{

	}

	public function GetData()
	{
		$result = new fornecedorModel();
		$aux = new MySQLAux();
		
		$result->setId($_POST['Id']);
		$result->setEstado($_POST['estados']);
		$result->setCidade($_POST['cidades']);
		$result->setConta($_POST['contas']);
		$result->setTipo($_POST['tipo']);
		
		if ($_POST['tipo'] == 'pj')
		{
			$result->setCnpj($aux->RetiraCaracteres($_POST['cnpj']));
			$result->setCpf(null);
		}
		else
		{
			$result->setCnpj(null);
			$result->setCpf($aux->RetiraCaracteres($_POST['cpf']));
		}
		
		$result->setNomeFantasia($_POST['nomefantasia']);
		$result->setRazaoSocial($_POST['razaosocial']);
		$result->setInscricaoMunicipal($_POST['inscricaomunicipal']);
		$result->setInscricaoEstadual($_POST['inscricaoestadual']);
		$result->setCep($_POST['cep']);
		$result->setEndereco($_POST['endereco']);
		$result->setBairro($_POST['bairro']);
		$result->setNumero($_POST['numero']);
		$result->setComplemento($_POST['complemento']);
		$result->setTelefone($_POST['telefone']);
		$result->setCelular($_POST['celular']);
		$result->setFax($_POST['fax']);
		$result->setSimplesNacional($_POST['simplesnacional']);
		$result->setCadastroSp($_POST['cadastrosp']);
		$result->setEmail($_POST['email']);
		$result->setOutrasInformacoes($_POST['outrasinformacoes']);
		$result->setNumeroBanco($_POST['banco']);
		$result->setAgencia($_POST['agencia']);
		$result->setContaCorrente($_POST['contacorrente']);
		$result->setContaResultado($_POST['contas_resultado']);

		return $result->save();
	}
	
	public function getTipoPessoa($pString)
	{
		if ($pString == 'pj')
		{
			return "Pessoa jurdica";
		}
		else
		{
			return "Pessoa fsica";
		}
	}
	
	public function VerificaPessoaJuridica($pessoa)
	{
		if($pessoa == 'pj')
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
}

?>