<?php
//USING
require_once '../Class/model/RecebimentosModel.php';
require_once '../Class/model/ClientesModel.php';
require_once '../Class/model/PastasModel.php';
include_once('../Database/MySQL.Aux.php');

/**
 * RecebimentosControl - Controle dos recebimentos
 *
 * Essa classe controla as requisicoes da classe Recebimentos
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */
class RecebimentosControl
{
	protected $id;
	protected $action;
	protected $deletar;

	public function setId()
	{
		if (isset($_GET['id']))
		{
			$this->id = $_GET['id'];
		}
	}

	public function getId()
	{
		return $this->id;
	}

	public function setAction()
	{
		if (isset($_POST['action']))
		{
			$this->action = $_POST['action'];
		}
	}

	public function getAction()
	{
		return $this->action;
	}

	public function setDel()
	{
		if (isset($_GET['del']))
		{
			$this->deletar = $_GET['del'];
		}
	}

	public function getDel()
	{
		return $this->deletar;
	}

	//Constructor
	public function __construct()
	{

	}
	
	public function getCliente($clienteId)
	{
		$cliente = new ClientesModel();
		$cliente->load($clienteId);
		return $cliente->getNomeFantasia();
	}
	
	public function getPasta($pastaId)
	{
		$pasta = new PastasModel();
		$pasta->load($pastaId);
		return $pasta->getNome();
	}
	
	public function GetData()
	{
		$result = new RecebimentosModel();
		$aux = new MySQLAux();
		
		$result->setId($_POST['Id']);
		$result->setCliente($_POST['cliente']);
		$result->setPasta($_POST['pasta']);
		$result->setTipo($_POST['tipo']);
		$result->setForma($_POST['forma']);
		$result->setBanco($_POST['banco']);
		$result->setNumeroNota($_POST['numeronota']);
		$result->setEmissao($aux->FormataData($_POST['emissao']));
		$result->setVencimento($aux->FormataData($_POST['vencimento']));
		$result->setJuros($aux->getValorEN($_POST['juros']));
		$result->setMulta($aux->getValorEN($_POST['multa']));
		$result->setDesconto($aux->getValorEN($_POST['desconto']));
		$result->setDetalhe($_POST['detalhe']);
		$result->setValor($aux->getValorEN($_POST['valor']));
		$result->setDtRecebimento($aux->FormataData($_POST['recebimento']));
		$result->setCheque($_POST['cheque']);

		return $result->save();
	}
}

?>