<?php
//USING
require_once '../Database/MySQL.Connection.php';
include_once('../Database/MySQL.Query.php');
include_once('../Database/MySQL.Aux.php');

/**
 * BancosModel
 *
 * Essa classe controla as propriedades e requisies do banco de dados dos usurios
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */

class BancosModel
{
	//Attributes
	protected $id;
	protected $nomConta;
	protected $numBanco;
	protected $agencia;
	protected $contaCorrente;
	protected $contaReduzida;
	protected $conn;

	public function setId($pValue)
	{
		$this->id = $pValue;
	}

	public function getId()
	{
		return $this->id;
	}

	public function setNomConta($pValue)
	{
		$this->nomConta = $pValue;
	}

	public function getNomConta()
	{
		return $this->nomConta;
	}

	public function setNumBanco($pValue)
	{
		$this->numBanco = $pValue;
	}

	public function getNumBanco()
	{
		return $this->numBanco;
	}

	public function setAgencia($pValue)
	{
		$this->agencia = $pValue;
	}

	public function getAgencia()
	{
		return $this->agencia;
	}

	public function setContaCorrente($pValue)
	{
		$this->contaCorrente = $pValue;
	}

	public function getContaCorrente()
	{
		return $this->contaCorrente;
	}
	
	public function setContaReduzida($pValue)
	{
		$this->contaReduzida = $pValue;
	}

	public function getContaReduzida()
	{
		return $this->contaReduzida;
	}

	//Constructor
	public function __construct()
	{
		$this->conn = new ConnectionFactory();
	}

	//Functions
	public function fillAttributes($row)
	{
		$this->setId($row['Id']);
		$this->setNomConta($row['NomeConta']);
		$this->setNumBanco($row['NumBanco']);
		$this->setAgencia($row['Agencia']);
		$this->setContaCorrente($row['ContaCorrente']);
		$this->setContaReduzida($row['NumContaReduzida']);
	}
	
	public function load($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_bancos WHERE Id = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}

	public function save()
	{
		try
		{
			if($this->id  > 0)
			{
				return $this->update();
			}
			else
			{
				return $this->insert();
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function insert()
	{
		try
		{
			$fields = array();
			
			array_push($fields, MySQLAux::CreateField('Nomeconta',$this->getNomConta(),'text'));
			array_push($fields, MySQLAux::CreateField('Numbanco',$this->getNumBanco(),'text'));
			array_push($fields, MySQLAux::CreateField('Agencia',$this->getAgencia(),'text'));
			array_push($fields, MySQLAux::CreateField('ContaCorrente',$this->getContaCorrente(),'text'));
			array_push($fields, MySQLAux::CreateField('NumContaReduzida',$this->getContaReduzida(),'number'));
			$this->setId($this->conn->ExecuteInsert(MySQLQuery::Insert('mfin_bancos',$fields))); 
			$success = $this->id > 0;

			return ($success);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function update()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Nomeconta',$this->getNomConta(),'text'));
			array_push($fields, MySQLAux::CreateField('Numbanco',$this->getNumBanco(),'text'));
			array_push($fields, MySQLAux::CreateField('Agencia',$this->getAgencia(),'text'));
			array_push($fields, MySQLAux::CreateField('ContaCorrente',$this->getContaCorrente(),'text'));
			array_push($fields, MySQLAux::CreateField('NumContaReduzida',$this->getContaReduzida(),'number'));

			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_bancos',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function delete()
	{
		try
		{
			return ($this->conn->ExecuteAffected("DELETE FROM mfin_bancos WHERE Id = $this->id") > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function listAll()
	{
		return $this->GenericList('SELECT * FROM mfin_bancos ORDER BY Id ASC');
	}

	public function GenericList($pQuery)
	{
		$result = $this->conn->ExecuteSelect($pQuery);
		$list = array();
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH))
			{
				$item = new BancosModel();
				$item->fillAttributes($row);
				array_push($list, $item);
			}
		}	
		return $list;
	}
}
?>