<?php
//USING
require_once '../Database/MySQL.Connection.php';
include_once('../Database/MySQL.Query.php');
include_once('../Database/MySQL.Aux.php');

/**
 * LoginModel
 *
 * Essa classe controla as propriedades e requisies do banco de dados dos usurios
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */

class EstadoModel
{
	//Attributes
	protected $id;
	protected $estado;
	protected $sigla;
	protected $conn;

	public function setId($pValue)
	{
		$this->id = $pValue;
	}

	public function getId()
	{
		return $this->id;
	}

	public function setEstado($pValue)
	{
		$this->estado = $pValue;
	}

	public function getEstado()
	{
		return $this->estado;
	}

	public function setSigla($pValue)
	{
		$this->sigla = $pValue;
	}

	public function getSigla()
	{
		return $this->sigla;
	}

	//Constructor
	public function __construct()
	{
		$this->conn = new ConnectionFactory();
	}

	//Functions
	public function fillAttributes($row)
	{
		$this->setId($row['Id']);
		$this->setEstado($row['Estado']);
		$this->setSigla($row['Sigla']);
	}

	public function load($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_estado WHERE Id = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}

	public function save()
	{
		try
		{
			if($this->id  > 0)
			{
				return $this->update();
			}
			else
			{
				return $this->insert();
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function insert()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Estado',$this->getEstado(),'text'));
			array_push($fields, MySQLAux::CreateField('Sigla',$this->getSigla(),'text'));
			$this->id = $this->conn->ExecuteInsert(MySQLQuery::Insert('mfin_estado',$fields));
			$success = $this->id > 0;

			return ($success);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function update()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Estado',$this->getEstado(),'text'));
			array_push($fields, MySQLAux::CreateField('Sigla',$this->getSigla(),'text'));
			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_estado',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function delete()
	{
		try
		{
			return ($this->conn->ExecuteAffected("DELETE FROM mfin_estado WHERE Id = $this->id") > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function listAll()
	{
		return self::GenericList('SELECT * FROM mfin_estado ORDER BY Id ASC ');
	}

	public function GenericList($pQuery)
	{
		$result = $this->conn->ExecuteSelect($pQuery);
		$list = array();
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH))
			{
				$item = new EstadoModel();
				$item->fillAttributes($row);
				array_push($list, $item);
			}
		}
	
		return $list;
	}
}
