<?php
//USING
require_once '../Database/MySQL.Connection.php';
include_once('../Database/MySQL.Query.php');
include_once('../Database/MySQL.Aux.php');

/**
 * FaturasDescricaoModel
 *
 * Essa classe controla as propriedades e requisies das descries das faturas
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */

class FaturasDescricaoModel
{
	//Attributes
	protected $id;
	protected $fatura;
	protected $descricao;
	protected $tipoRecebimento;
	protected $valor;
	protected $conn;

	public function setId($pValue)
	{
		$this->id = $pValue;
	}

	public function getId()
	{
		return $this->id;
	}

	public function setFatura($pValue)
	{
		$this->fatura = $pValue;
	}

	public function getFatura()
	{
		return $this->fatura;
	}

	public function setDescricao($pValue)
	{
		$this->descricao = $pValue;
	}

	public function getDescricao()
	{
		return $this->descricao;
	}

	public function setTipoRecebimento($pValue)
	{
		$this->tipoRecebimento = $pValue;
	}

	public function getTipoRecebimento()
	{
		return $this->tipoRecebimento;
	}

	public function setValor($pValue)
	{
		$this->valor = $pValue;
	}

	public function getValor()
	{
		return $this->valor;
	}

	//Constructor
	public function __construct()
	{
		$this->conn = new ConnectionFactory();
	}

	//Functions
	public function fillAttributes($row)
	{
		$this->setId($row['Id']);
		$this->setFatura($row['Fatura']);
		$this->setDescricao($row['Descricao']);
		$this->setTipoRecebimento($row['TipoRecebimento']);
		$this->setValor($row['Valor']);
	}

	public function load($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_faturasdescricao WHERE Id = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}
	
	public function loadbyFatura($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_faturasdescricao WHERE Fatura = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}

	public function save()
	{
		try
		{
			if($this->id > 0)
			{
				return $this->update();
			}
			else
			{
				return $this->insert();
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function insert()
	{
		try
		{
			$fields = array();
			
			array_push($fields, MySQLAux::CreateField('Fatura',$this->getFatura(),'number'));
			array_push($fields, MySQLAux::CreateField('Descricao',$this->getDescricao(),'text'));
			array_push($fields, MySQLAux::CreateField('TipoRecebimento',$this->getTipoRecebimento(),'number'));
			array_push($fields, MySQLAux::CreateField('Valor',$this->getValor(),'decimal'));
			$this->setId($this->conn->ExecuteInsert(MySQLQuery::Insert('mfin_faturasdescricao',$fields))); 
			$success = $this->id > 0;

			return ($success);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function update()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Fatura',$this->getFatura(),'number'));
			array_push($fields, MySQLAux::CreateField('Descricao',$this->getDescricao(),'text'));
			array_push($fields, MySQLAux::CreateField('TipoRecebimento',$this->getTipoRecebimento(),'number'));
			array_push($fields, MySQLAux::CreateField('Valor',$this->getValor(),'decimal'));

			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_faturasdescricao',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function delete()
	{
		try
		{
			return ($this->conn->ExecuteAffected("DELETE FROM mfin_faturasdescricao WHERE Id = $this->id") > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}
	
	public function deleteByFatura($id)
	{
		try
		{
			return ($this->conn->ExecuteAffected("DELETE FROM mfin_faturasdescricao WHERE Fatura = $id") > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function listAll()
	{
		return self::GenericList('SELECT * FROM mfin_faturasdescricao ORDER BY Id ASC');
	}
	
	public function listAllByFatura($id)
	{
		return self::GenericList("SELECT * FROM mfin_faturasdescricao WHERE Fatura = $id");
	}

	public function GenericList($pQuery)
	{
		$result = $this->conn->ExecuteSelect($pQuery);
		$list = array();
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH))
			{
				$item = new FaturasDescricaoModel();
				$item->fillAttributes($row);
				array_push($list, $item);
			}
		}	
		return $list;
	}
}
?>