<?php
//USING
require_once '../Database/MySQL.Connection.php';
include_once('../Database/MySQL.Query.php');
include_once('../Database/MySQL.Aux.php');

/**
 * LoginModel
 *
 * Essa classe controla as propriedades e requisies do banco de dados dos usurios
 *
 * @version 	1.0
 * @project 	Mdulo Financeiro
 * @copyright	Jay.com.br 2012
 * @access 		public
 */

class PastasModel
{
	//Attributes
	protected $id;
	protected $numero;
	protected $nome;
	protected $detalhe;
	protected $conn;

	public function setId($pValue)
	{
		$this->id = $pValue;
	}

	public function getId()
	{
		return $this->id;
	}

	public function setNumero($pValue)
	{
		$this->numero = $pValue;
	}

	public function getNumero()
	{
		return $this->numero;
	}

	public function setNome($pValue)
	{
		$this->nome = $pValue;
	}

	public function getNome()
	{
		return $this->nome;
	}

	public function setDetalhe($pValue)
	{
		$this->detalhe = $pValue;
	}

	public function getDetalhe()
	{
		return $this->detalhe;
	}

	//Constructor
	public function __construct()
	{
		$this->conn = new ConnectionFactory();
	}

	//Functions
	public function fillAttributes($row)
	{		
		$this->setId($row['Id']);
		$this->setNumero($row['Numero']);
		$this->setNome($row['Nome']);
		$this->setDetalhe($row['Detalhe']);
	}

	public function load($id)
	{
		$result = $this->conn->ExecuteSelect("SELECT * FROM mfin_pastas WHERE Id = $id ");

		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH)) 
			{
				$this->FillAttributes($row);
			}
		}
	}

	public function save()
	{
		try
		{
			if($this->id  > 0)
			{
				return $this->update();
			}
			else
			{
				return $this->insert();
			}
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function insert()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Numero',$this->getNumero(),'number'));
			array_push($fields, MySQLAux::CreateField('Nome',$this->getNome(),'text'));
			array_push($fields, MySQLAux::CreateField('Detalhe',$this->getDetalhe(),'text'));
			$this->id = $this->conn->ExecuteInsert(MySQLQuery::Insert('mfin_pastas',$fields));
			$success = $this->id > 0;

			return ($success);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function update()
	{
		try
		{
			$fields = array();
			array_push($fields, MySQLAux::CreateField('Numero',$this->getNumero(),'number'));
			array_push($fields, MySQLAux::CreateField('Nome',$this->getNome(),'text'));
			array_push($fields, MySQLAux::CreateField('Detalhe',$this->getDetalhe(),'text'));
			return ($this->conn->ExecuteAffected(MySQLQuery::Update('mfin_pastas',$fields,MySQLAux::CreateField('Id',"$this->id",'number'))) > 0);
		}
		catch(Exception $err)
		{

			echo($err);
			return false;
		}
	}

	public function delete()
	{
		try
		{
			return ($this->conn->ExecuteAffected("DELETE FROM mfin_pastas WHERE Id = $this->id") > 0);
		}
		catch(Exception $err)
		{
			echo($err);
			return false;
		}
	}

	public function listAll()
	{
		return self::GenericList('SELECT * FROM mfin_pastas ORDER BY Numero ASC');
	}

	public function GenericList($pQuery)
	{
		$result = $this->conn->ExecuteSelect($pQuery);
		$list = array();
		if(!$result)
		{
			echo(mysql_error());
		}
		else
		{
			while ($row = mysql_fetch_array($result, MYSQL_BOTH))
			{
				$item = new PastasModel();
				$item->fillAttributes($row);
				array_push($list, $item);
			}
		}	
		return $list;
	}
}
