$(function() {
  
  
  $("#form1").validate({
      rules: {
         nome: {required: true},
         documento: {documento: true}
      },
      messages: {
         nome: {required: 'Informe o nome' },
         documento: { documento: 'Documento invlido.'}
      },
      submitHandler:function(form) {
         alert('ok');
      }
   });
  
  
  
});

jQuery.validator.addMethod("documento", function(value, element) {

  // remove pontuaes
  value = value.replace('.','');
  value = value.replace('.','');
  value = value.replace('-','');
  value = value.replace('/','');

  if (value.length <= 11) {
    if(jQuery.validator.methods.cpf.call(this, value, element)){
      return true;
    } else {
      this.settings.messages.documento.documento = "Informe um CPF vlido.";
    }

  }
  else if (value.length <= 14) {
    if(jQuery.validator.methods.cnpj.call(this, value, element)){
      return true;
    } else {
      this.settings.messages.documento.documento = "Informe um CNPJ vlido.";
    }

  }

  return false;

}, "Informe um documento vlido.");





// validao do CPF
jQuery.validator.addMethod("cpf", function(value, element) {
   value = jQuery.trim(value);
	
	value = value.replace('.','');
	value = value.replace('.','');
	cpf = value.replace('-','');
	while(cpf.length < 11) cpf = "0"+ cpf;
	var expReg = /^0+$|^1+$|^2+$|^3+$|^4+$|^5+$|^6+$|^7+$|^8+$|^9+$/;
	var a = [];
	var b =0;
	var c = 11;
	for (i=0; i<11; i++){
		a[i] = cpf.charAt(i);
		if (i < 9) b += (a[i] * --c);
	}
        if ((x = b % 11) < 2) { a[9] = 0; } else { a[9] = 11-x; }          
	b = 0;
	c = 11;
	for (y=0; y<10; y++) b += (a[y] * c--);
	if ((x = b % 11) < 2) { a[10] = 0; } else { a[10] = 11-x; }
	
	var retorno = true;
	if ((cpf.charAt(9) != a[9]) || (cpf.charAt(10) != a[10]) || cpf.match(expReg)) retorno = false;
	
	return this.optional(element) || retorno;

}, "Informe um CPF vlido."); 


// validao do CNPJ
jQuery.validator.addMethod("cnpj", function(cnpj, element) {
   cnpj = jQuery.trim(cnpj);// retira espaos em branco
   // DEIXA APENAS OS NMEROS
   cnpj = cnpj.replace('/','');
   cnpj = cnpj.replace('.','');
   cnpj = cnpj.replace('.','');
   cnpj = cnpj.replace('-','');
 
   var numeros, digitos, soma, i, resultado, pos, tamanho, digitos_iguais;
   digitos_iguais = 1;
 
   if (cnpj.length < 14 && cnpj.length < 15){
      return false;
   }
   for (i = 0; i < cnpj.length - 1; i++){
      if (cnpj.charAt(i) != cnpj.charAt(i + 1)){
         digitos_iguais = 0;
         break;
      }
   }
 
   if (!digitos_iguais){
      tamanho = cnpj.length - 2;
      numeros = cnpj.substring(0,tamanho);
      digitos = cnpj.substring(tamanho);
      soma = 0;
      pos = tamanho - 7;
 
      for (i = tamanho; i >= 1; i--){
         soma += numeros.charAt(tamanho - i) * pos--;
         if (pos < 2){
            pos = 9;
         }
      }
      resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
      if (resultado != digitos.charAt(0)){
         return false;
      }
      tamanho = tamanho + 1;
      numeros = cnpj.substring(0,tamanho);
      soma = 0;
      pos = tamanho - 7;
      for (i = tamanho; i >= 1; i--){
         soma += numeros.charAt(tamanho - i) * pos--;
         if (pos < 2){
            pos = 9;
         }
      }
      resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
      if (resultado != digitos.charAt(1)){
         return false;
      }
      return true;
   }else{
      return false;
   }
}, "Informe um CNPJ vlido."); // Mensagem padro 
